/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.upgrades.radio;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.peripherals.AbstractRadioPeripheral;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class TurtleRadio
implements ITurtleUpgrade {
    private final ResourceLocation id;
    private final ItemStack stack;

    public TurtleRadio(ResourceLocation id, ItemStack stack) {
        this.id = id;
        this.stack = stack;
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.PERIPHERAL;
    }

    public @Nullable IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new RadioTurtlePeripheral(turtle);
    }

    public ResourceLocation getUpgradeID() {
        return this.id;
    }

    public String getUnlocalisedAdjective() {
        return "upgrade.radio.adjective";
    }

    public ItemStack getCraftingItem() {
        return this.stack;
    }

    public static class RadioTurtlePeripheral
    extends AbstractRadioPeripheral {
        private final ITurtleAccess turtle;

        public RadioTurtlePeripheral(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Level getLevel() {
            return this.turtle.getLevel();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82528_((Vec3i)this.turtle.getPosition());
        }

        @Override
        public double getRange() {
            return 0.0;
        }

        @Override
        public void ping() {
        }

        @Override
        public boolean canBroadcast() {
            return ClassicPeripherals.CONFIG.antennaCanBroadcast;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof RadioTurtlePeripheral)) return false;
            RadioTurtlePeripheral o = (RadioTurtlePeripheral)other;
            if (this.turtle != o.turtle) return false;
            return true;
        }
    }
}

