package me.alexdevs.classicPeripherals;

import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.peripherals.Peripherals;
import me.alexdevs.classicPeripherals.recipe.ModRecipes;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.nio.file.Paths;

public class ClassicPeripherals implements ModInitializer {
    public static final String MOD_ID = "classicperipherals";

    public static final ClassicPeripheralsConfig CONFIG = ClassicPeripheralsConfig.createToml(
            FabricLoader.getInstance().getConfigDir(),
            "",
            MOD_ID,
            ClassicPeripheralsConfig.class
    );

    public static final class_5321<class_1761> CREATIVE_TAB_KEY = class_5321.method_29179(class_7924.field_44688, new class_2960(MOD_ID, "item_group"));
    public static final class_1761 CREATIVE_TAB = FabricItemGroup.builder()
            .method_47320(() -> new class_1799(ModBlocks.TOWER_HEAD))
            .method_47321(class_2561.method_43471("itemGroup.classicperipherals"))
            .method_47324();

    @Override
    public void onInitialize() {
        ModBlocks.initialize();
        ModBlockTiles.initialize();
        ModItems.initialize();
        Peripherals.register();
        ModRecipes.initialize();

        class_2378.method_39197(class_7923.field_44687, CREATIVE_TAB_KEY, CREATIVE_TAB);

        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((tab, entries) -> {
            if (tab == CREATIVE_TAB) {
                entries.method_45421(ModBlocks.TOWER_BASE);
                entries.method_45421(ModBlocks.TOWER_SEGMENT);
                entries.method_45421(ModBlocks.TOWER_HEAD);
                entries.method_45421(ModBlocks.ANTENNA);
                entries.method_45421(ModItems.COPPER_COIL);
                entries.method_45421(ModBlocks.NFC_READER);
                entries.method_45421(ModItems.NFC_CARD);
                entries.method_45421(ModBlocks.RFID_SCANNER);
                entries.method_45421(ModItems.RFID_BADGE);
            }
        });

        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                var tag = stack.method_7948();
                if (tag.method_10545("color")) {
                    return tag.method_10550("color");
                }
            }

            return 0xFFFFFF;
        }, ModItems.NFC_CARD);

        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                var tag = stack.method_7948();
                if (tag.method_10545("color")) {
                    return tag.method_10550("color");
                }
            }

            return 0xFFFFFF;
        }, ModItems.RFID_BADGE);
    }
}
