package me.alexdevs.classicPeripherals.recipe;

import dan200.computercraft.shared.util.ColourTracker;
import me.alexdevs.classicPeripherals.item.ModItems;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class RfidBadgeRecipe extends class_1852 {
    public RfidBadgeRecipe(class_2960 id, class_7710 category) {
        super(id, category);
    }

    @Override
    public boolean matches(class_8566 container, class_1937 level) {
        var hasItem = false;
        var tracker = new ColourTracker();

        for (int i = 0; i < container.method_5439(); i++) {
            var stack = container.method_5438(i);
            if (stack.method_7960()) {
                continue;
            }

            if (stack.method_31574(ModItems.RFID_BADGE)) {
                hasItem = true;
            } else if (stack.method_7909() instanceof class_1769 dye) {
                tracker.addColour(dye.method_7802());
            }
        }

        return hasItem && tracker.hasColour();
    }

    @Override
    public @NotNull class_1799 assemble(class_8566 container, class_5455 registryAccess) {
        class_1799 item = null;
        var tracker = new ColourTracker();

        for (int i = 0; i < container.method_5439(); i++) {
            class_1799 stack = container.method_5438(i);
            if (!stack.method_7960()) {
                if (stack.method_31574(ModItems.RFID_BADGE)) {
                    item = stack.method_7972();
                    item.method_7939(1);
                    if (item.method_7985()) {
                        var tag = item.method_7948();
                        if (tag.method_10545("color")) {
                            var value = tag.method_10550("color");
                            var r = value >> 16 & 0xFF;
                            var g = value >> 8 & 0xFF;
                            var b = value & 0xFF;

                            tracker.addColour(r, g, b);
                        }
                    }
                } else if (stack.method_7909() instanceof class_1769 dye) {
                    tracker.addColour(dye.method_7802());
                }
            }
        }

        if (item != null && tracker.hasColour()) {
            item.method_7948().method_10569("color", tracker.getColour());
            return item;
        }

        return class_1799.field_8037;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public @NotNull class_1865<?> method_8119() {
        return ModRecipes.RFID_BADGE_RECIPE;
    }
}
