/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.mixin;

import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.network.PacketReceiver;
import dan200.computercraft.api.network.PacketSender;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WirelessNetwork.class})
public abstract class WirelessNetworkMixin {
    @Inject(method={"tryTransmit"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void tryTransmit(PacketReceiver receiver, Packet packet, double range, boolean interdimensional, CallbackInfo ci) {
        if (ClassicPeripherals.CONFIG.enderModemNerf) {
            return;
        }
        ci.cancel();
        PacketSender sender = packet.sender();
        if (receiver.getLevel() == sender.getLevel()) {
            double receiveRange = Math.max(range, receiver.getRange());
            double distanceSq = receiver.getPosition().distanceToSqr(sender.getPosition());
            if (distanceSq <= receiveRange * receiveRange) {
                receiver.receiveSameDimension(packet, Math.sqrt(distanceSq));
            }
        } else if (interdimensional) {
            Level originLevel = packet.sender().getLevel();
            Level destinationLevel = receiver.getLevel();
            double scale = DimensionType.getTeleportationScale((DimensionType)originLevel.dimensionType(), (DimensionType)destinationLevel.dimensionType());
            Vec3 receiverPos = receiver.getPosition().multiply(scale, 1.0, scale);
            double distanceSq = receiverPos.distanceToSqr(sender.getPosition());
            if (Math.sqrt(distanceSq) <= 8.0) {
                receiver.receiveDifferentDimension(packet);
            }
        }
    }
}

