/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import java.util.NoSuchElementException;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.tower.TowerHeadBlock;
import me.alexdevs.classicPeripherals.tiles.AbstractRadioBlockEntity;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TowerBlockEntity
extends AbstractRadioBlockEntity {
    protected BlockPos headPos;

    public TowerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockTiles.TOWER_BASE.get(), pos, state);
    }

    @Override
    public void validate() {
        this.towerHeight = 1;
        this.isValid = false;
        BlockPos pos = this.getBlockPos();
        for (int i = 1; i < ClassicPeripherals.CONFIG.radioTowerMaxHeight && this.level.getBlockState(pos = pos.above(1)).is(ModBlocks.TOWER_SEGMENT); ++i) {
            ++this.towerHeight;
        }
        if (!this.level.getBlockState(pos).is(ModBlocks.TOWER_HEAD)) {
            this.invalidate();
            return;
        }
        ++this.towerHeight;
        if (this.towerHeight < ClassicPeripherals.CONFIG.radioTowerMinHeight) {
            this.invalidate();
            return;
        }
        this.headPos = pos.immutable();
        super.validate();
    }

    @Override
    public void ping() {
        try {
            BlockState head = this.level.getBlockState(this.getAntennaPos());
            this.level.setBlockAndUpdate(this.getAntennaPos(), (BlockState)head.setValue((Property)TowerHeadBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
            this.level.scheduleTick(this.getAntennaPos(), (Block)ModBlocks.TOWER_HEAD.get(), 4);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public BlockPos getAntennaPos() {
        return this.headPos;
    }
}

