package me.alexdevs.classicPeripherals.tiles;

import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.tower.TowerHeadBlock;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class TowerBlockEntity extends AbstractRadioBlockEntity {

    protected class_2338 headPos;

    public TowerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockTiles.TOWER_BASE, pos, state);
    }

    public void validate() {
        towerHeight = 1;
        isValid = false;
        var pos = this.method_11016();
        for (int i = 1; i < ClassicPeripherals.CONFIG.radioTowerMaxHeight; i++) {
            pos = pos.method_10086(1);
            if (this.field_11863.method_8320(pos).method_27852(ModBlocks.TOWER_SEGMENT)) {
                towerHeight++;
            } else {
                break;
            }
        }

        if (!this.field_11863.method_8320(pos).method_27852(ModBlocks.TOWER_HEAD)) {
            invalidate();
            return;
        }
        towerHeight++;

        if (towerHeight < ClassicPeripherals.CONFIG.radioTowerMinHeight) {
            invalidate();
            return;
        }

        headPos = pos.method_10062();
        super.validate();
    }

    @Override
    protected void onPing() {
        if(field_11863 != null) {
            var head = field_11863.method_8320(getAntennaPos());
            this.field_11863.method_8501(getAntennaPos(), head.method_11657(TowerHeadBlock.ACTIVE, true));
        }
    }

    @Override
    protected void afterPing() {
        if(field_11863 != null) {
            var head = field_11863.method_8320(getAntennaPos());
            this.field_11863.method_8501(getAntennaPos(), head.method_11657(TowerHeadBlock.ACTIVE, false));
        }
    }

    @Override
    public class_2338 getAntennaPos() {
        return headPos;
    }
}
