/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals;

import folk.sisby.kaleido.api.WrappedConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.FloatRange;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.IntegerRange;

public class ClassicPeripheralsConfig
extends WrappedConfig {
    @Comment(value={"The maximum height of the radio tower. Including base and head."})
    @IntegerRange(min=2L, max=0x7FFFFFFFL)
    public int radioTowerMaxHeight = 24;
    @Comment(value={"The minimum height of the radio tower. Including base and head."})
    @IntegerRange(min=2L, max=0x7FFFFFFFL)
    public int radioTowerMinHeight = 2;
    @Comment(value={"Range per segment."})
    @IntegerRange(min=1L, max=0x7FFFFFFFL)
    public int radioTowerSegmentRange = 128;
    @Comment(value={"The loss factor of the radio tower."})
    @FloatRange(min=0.0, max=1.0)
    public double radioTowerLossFactor = 0.15;
    @Comment(value={"The maximum message size in bytes."})
    @IntegerRange(min=1L, max=0x7FFFFFFFL)
    public int radioTowerMaxMessageSize = 0x800000;
    @Comment(value={"The maximum size in bytes of the NFC card and RFID badge data."})
    @IntegerRange(min=1L, max=0x7FFFFFFFL)
    public int nfcMaxDataSize = 128;
    @Comment(value={"The maximum range of the RFID scanner."})
    @IntegerRange(min=1L, max=0x7FFFFFFFL)
    public int rfidScanRange = 8;
    @Comment(value={"Enable the Ender Modem nerf."})
    public boolean enderModemNerf = true;
    @Comment(value={"Enable the improvement of the Redstone Relay event."})
    public boolean betterRedstoneRelayEvent = true;
}

