package me.alexdevs.classicPeripherals.recipe;

import dan200.computercraft.shared.util.ColourTracker;
import me.alexdevs.classicPeripherals.ModComponents;
import me.alexdevs.classicPeripherals.item.ModItems;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9323;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;

public class NfcCardRecipe extends class_1852 {


    public NfcCardRecipe(class_7710 category) {
        super(category);
    }

    @Override
    public boolean matches(class_9694 container, class_1937 level) {
        var hasItem = false;
        var tracker = new ColourTracker();

        for (int i = 0; i < container.method_59983(); i++) {
            var stack = container.method_59984(i);
            if (stack.method_7960()) {
                continue;
            }

            if (stack.method_31574(ModItems.NFC_CARD)) {
                hasItem = true;
            } else if (stack.method_7909() instanceof class_1769 dye) {
                tracker.addColour(dye.method_7802());
            }
        }

        return hasItem && tracker.hasColour();
    }

    @Override
    public @NotNull class_1799 assemble(class_9694 container, class_7225.class_7874 registries) {
        class_1799 item = null;
        var tracker = new ColourTracker();

        for (int i = 0; i < container.method_59983(); i++) {
            class_1799 stack = container.method_59984(i);
            if (!stack.method_7960()) {
                if (stack.method_31574(ModItems.NFC_CARD)) {
                    item = stack.method_7972();
                    item.method_7939(1);
                    var tag = item.method_57353();
                    if (tag.method_57832(ModComponents.NFC_COLOR)) {
                        int value = tag.method_57830(ModComponents.NFC_COLOR, 0xFFFFFF);
                        var r = value >> 16 & 0xFF;
                        var g = value >> 8 & 0xFF;
                        var b = value & 0xFF;

                        tracker.addColour(r, g, b);
                    }
                } else if (stack.method_7909() instanceof class_1769 dye) {
                    tracker.addColour(dye.method_7802());
                }
            }
        }

        if (item != null && tracker.hasColour()) {
            item.method_57365(class_9323.method_57827()
                    .method_57840(ModComponents.NFC_COLOR, tracker.getColour())
                    .method_57838());
            return item;
        }

        return class_1799.field_8037;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public @NotNull class_1865<?> method_8119() {
        return ModRecipes.NFC_CARD_DYE;
    }
}
