/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import dan200.computercraft.api.peripheral.IPeripheral;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.peripherals.RadioPeripheral;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractRadioBlockEntity
extends BlockEntity {
    public static final int MAX_HEIGHT = 24;
    public static final int MIN_HEIGHT = 2;
    public static final int SEGMENT_RANGE = 128;
    public static final double LOSS_FACTOR = 0.15;
    protected final Random random = new Random();
    protected int towerHeight = 1;
    protected boolean isValid = true;
    protected int channel = 0;
    protected BlockPos topPos;
    protected final RadioPeripheral peripheral = new RadioPeripheral(this);
    protected boolean initialized = false;

    public AbstractRadioBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.topPos = pos;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("radio_channel")) {
            this.setChannel(nbt.getInt("radio_channel"));
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("radio_channel", this.getChannel());
    }

    public void setRemoved() {
        super.setRemoved();
        this.invalidate();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractRadioBlockEntity be) {
        if (!be.initialized) {
            be.initialized = true;
            be.validate();
        }
    }

    public boolean canBroadcast() {
        return this.isValid;
    }

    public void validate() {
        this.isValid = true;
        TowerNetwork.addTower(this);
    }

    public void invalidate() {
        this.isValid = false;
        TowerNetwork.removeTower(this);
    }

    public abstract void ping();

    public int getHeight() {
        return this.towerHeight;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public BlockPos getTopPos() {
        return this.topPos;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    public int getMaximumRange() {
        if (!this.isValid) {
            return 0;
        }
        return 128 * this.towerHeight;
    }

    public int getSafeRange() {
        int range = this.getMaximumRange();
        return range - (int)((double)range * 0.15);
    }

    public int getEffectiveMaxRange() {
        int y = this.getTopPos().getY();
        int range = this.getMaximumRange();
        if (y >= 96) {
            return range;
        }
        return Math.max(8, (int)(96.0 * (1.0 - Math.pow(Math.E, -0.05 * (double)y)) / 100.0 * (double)range));
    }

    public int getEffectiveSafeRange() {
        int effectiveRange = this.getEffectiveMaxRange();
        return effectiveRange - (int)((double)effectiveRange * 0.15);
    }

    public boolean inRange(AbstractRadioBlockEntity other) {
        int range = Math.max(this.getMaximumRange(), other.getMaximumRange());
        double distance = this.topPos.distSqr((Vec3i)other.topPos);
        return distance <= (double)(range * range);
    }

    public void receive(String message, double distance, AbstractRadioBlockEntity source) {
        if (!this.isValid()) {
            return;
        }
        this.ping();
        int safeRange = Math.max(this.getEffectiveSafeRange(), source.getEffectiveSafeRange());
        if (distance > (double)safeRange) {
            int maxRange = Math.max(this.getEffectiveMaxRange(), source.getEffectiveMaxRange());
            int unsafeRange = maxRange - safeRange;
            double distanceInUnsafe = distance - (double)safeRange;
            double corruption = distanceInUnsafe / (double)unsafeRange;
            message = this.flipString(message, corruption);
        }
        String data = message;
        this.peripheral.receive(data, distance);
    }

    protected String flipString(String data, double percentage) {
        byte[] bytes = data.getBytes(StandardCharsets.US_ASCII);
        int total = bytes.length * 8;
        int toFlip = (int)Math.ceil((double)total * percentage);
        for (int i = 0; i < toFlip; ++i) {
            int bit = this.random.nextInt(total);
            int byteIndex = bit / 8;
            int bitIndex = bit % 8;
            int n = byteIndex;
            bytes[n] = (byte)(bytes[n] ^ (byte)(1 << bitIndex));
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

