package me.alexdevs.classicPeripherals.item;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import me.alexdevs.classicPeripherals.ModComponents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NfcCardItem extends class_1792 {
    public NfcCardItem(class_1793 properties) {
        super(properties);
    }

    public static Optional<String> getData(class_1799 stack) {
        var data = stack.method_57353().method_57829(ModComponents.NFC_DATA);
        if (data == null || data.isEmpty()) {
            return Optional.empty();
        }

        return Optional.of(data);
    }

    @Override
    public @NotNull class_1269 method_7847(class_1799 stack, class_1657 source, class_1309 target, class_1268 usedHand) {
        if (source.method_37908().method_8608()) {
            if (target instanceof class_1657) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }

        var data = getData(stack);
        if (data.isEmpty()) {
            return class_1269.field_5811;
        }

        if (!(target instanceof class_3222 player)) {
            return class_1269.field_5811;
        }

        var inv = player.method_31548();
        if (inv.method_7382(ComputerCraftTags.Items.POCKET_COMPUTERS)) {
            var computers = getAllPocketComputers(player);

            computers.forEach(computer -> computer.queueEvent("nfc_data", new Object[]{"internal", data.get()}));
        }

        return class_1269.field_21466;
    }

    private static List<ServerComputer> getAllPocketComputers(class_3222 player) {
        var list = new ArrayList<ServerComputer>();
        var inventory = player.method_31548();
        for (var i = 0; i < inventory.method_5439(); i++) {
            var item = inventory.method_5438(i);
            if (item.method_40133().anyMatch(x -> x == ComputerCraftTags.Items.POCKET_COMPUTERS)) {
                var computer = PocketComputerItem.getServerComputer(player.method_5682(), item);
                list.add(computer);
            }
        }

        return list;
    }
}
