package me.alexdevs.classicPeripherals.peripherals;

import dan200.computercraft.api.peripheral.PeripheralLookup;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiFunction;

public class Peripherals {
    public static void register() {
        var peripherals = new BlockComponentImpl<>(PeripheralLookup.get());
        peripherals.registerForBlockEntity(ModBlockTiles.TOWER_BASE, (block, dir) -> dir == class_2350.field_11033 ? block.peripheral() : null);
        peripherals.registerForBlockEntity(ModBlockTiles.ANTENNA, (block, dir) -> dir == class_2350.field_11033 ? block.peripheral() : null);
        peripherals.registerForBlockEntity(ModBlockTiles.NFC_READER, (block, dir) -> block.peripheral());
    }

    public interface BlockComponent<T, C extends @Nullable Object> {
        <B extends class_2586> void registerForBlockEntity(class_2591<B> blockEntityType, BiFunction<? super B, C, @Nullable T> provider);
    }

    private record BlockComponentImpl<T, C extends @Nullable Object>(
            BlockApiLookup<T, C> lookup
    ) implements BlockComponent<T, C> {
        @Override
        public <B extends class_2586> void registerForBlockEntity(class_2591<B> blockEntityType, BiFunction<? super B, C, @Nullable T> provider) {
            lookup.registerForBlockEntity(provider, blockEntityType);
        }
    }
}
