package me.alexdevs.classicPeripherals.tiles;

import me.alexdevs.classicPeripherals.ModComponents;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.NfcReaderBlock;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.NfcReaderPeripheral;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;

public class NfcReaderBlockEntity extends class_2586 {
    public static final int MAX_DATA_SIZE = 128;

    protected final NfcReaderPeripheral peripheral = new NfcReaderPeripheral(this);

    private boolean writeMode = false;
    private String pendingWriteData = "";
    @Nullable
    private String pendingLabel = null;
    private boolean pendingReadOnly = false;

    public NfcReaderBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockTiles.NFC_READER, pos, blockState);
    }

    public NfcReaderPeripheral peripheral() {
        return peripheral;
    }

    public void flagWrite(String data, @Nullable String label, Boolean flagReadOnly) {
        writeMode = true;
        pendingWriteData = data.substring(0, Math.min(data.length(), MAX_DATA_SIZE));
        pendingLabel = label;
        pendingReadOnly = flagReadOnly;

        field_11863.method_8501(method_11016(), method_11010().method_11657(NfcReaderBlock.STATE, NfcReaderBlock.NfcReaderState.WRITING));
    }

    public void cancelWrite() {
        writeMode = false;
        pendingWriteData = "";
        pendingLabel = null;
        pendingReadOnly = false;

        field_11863.method_8501(method_11016(), method_11010().method_11657(NfcReaderBlock.STATE, NfcReaderBlock.NfcReaderState.NONE));
    }

    public boolean isWriteMode() {
        return writeMode;
    }

    public void pingRead() {
        this.method_10997().method_8501(method_11016(), method_11010().method_11657(NfcReaderBlock.STATE, NfcReaderBlock.NfcReaderState.READING));
        field_11863.method_39279(method_11016(), ModBlocks.NFC_READER, 10);
    }

    public void onUse(class_1799 stack) {
        if (writeMode) {
            var components = stack.method_57353();
            var readOnly = components.method_57830(ModComponents.NFC_READONLY, false);
            if (readOnly) {
                peripheral.writeFeedback(false, "read_only");
                cancelWrite();
                return;
            }

            var mapBuilder = class_9323.method_57827();

            if (pendingLabel != null) {
                mapBuilder.method_57840(class_9334.field_49631, class_2561.method_43470(pendingLabel));
            } else {
                stack.method_57381(class_9334.field_49631);
            }

            mapBuilder.method_57840(ModComponents.NFC_DATA, pendingWriteData);
            mapBuilder.method_57840(ModComponents.NFC_READONLY, pendingReadOnly);

            stack.method_57365(mapBuilder.method_57838());

            peripheral.writeFeedback(true, "success");
            cancelWrite();
        } else {
            var data = NfcCardItem.getData(stack);
            if (data.isPresent()) {
                peripheral.read(data.get());
                pingRead();
            }
        }
    }
}
