/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.peripherals;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.tiles.AbstractRadioBlockEntity;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;
import oshi.annotation.concurrent.GuardedBy;

public class RadioPeripheral
implements IPeripheral {
    private final AbstractRadioBlockEntity tile;
    @GuardedBy(value="computers")
    private final AttachedComputerSet computers = new AttachedComputerSet();
    private int channel = 0;

    public RadioPeripheral(AbstractRadioBlockEntity tile) {
        this.tile = tile;
    }

    public String getType() {
        return "radio_tower";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (this == other) return true;
        if (!(other instanceof RadioPeripheral)) return false;
        RadioPeripheral o = (RadioPeripheral)other;
        if (this.tile != o.tile) return false;
        return true;
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
        TowerNetwork.addReceiver(this);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        if (!this.computers.hasComputers()) {
            TowerNetwork.removeReceiver(this);
        }
    }

    public Level getLevel() {
        return this.tile.getLevel();
    }

    public Vec3 getPosition() {
        return Vec3.atLowerCornerOf((Vec3i)this.tile.getBlockPos());
    }

    public double getRange() {
        return this.tile.getEffectiveMaxRange();
    }

    public AbstractRadioBlockEntity getTile() {
        return this.tile;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(String data, double distance, double range) {
        if (!this.isValid()) {
            return;
        }
        double safeRange = AbstractRadioBlockEntity.getSafeRange(range);
        if (distance > safeRange) {
            double unsafeRange = range - safeRange;
            double distanceInUnsafe = distance - safeRange;
            double corruption = distanceInUnsafe / unsafeRange;
            data = this.tile.flipString(data, corruption);
        }
        String mutatedData = data;
        AttachedComputerSet attachedComputerSet = this.computers;
        synchronized (attachedComputerSet) {
            this.computers.forEach(computer -> computer.queueEvent("radio_message", new Object[]{computer.getAttachmentName(), mutatedData, distance}));
        }
        this.tile.ping();
    }

    @LuaFunction
    public final boolean isValid() {
        return this.tile.isValid();
    }

    @LuaFunction
    public final void broadcast(String data) throws LuaException {
        if (!this.tile.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        if (!this.tile.canBroadcast()) {
            throw new LuaException("This antenna is not capable of broadcasting.");
        }
        TowerNetwork.broadcast(this, data, this.tile.getEffectiveMaxRange());
        this.tile.ping();
    }

    @LuaFunction
    public final boolean canBroadcast() {
        return this.tile.canBroadcast();
    }

    @LuaFunction(mainThread=true)
    public final void setFrequency(ILuaContext context, int frequency) throws LuaException {
        if (frequency < 0 || frequency > 65535) {
            throw new LuaException("Frequency out of range. Must be between 0 and 65535.");
        }
        if (!this.tile.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        int channel = TowerNetwork.getChannel(frequency);
        this.setChannel(channel);
    }

    @LuaFunction
    public final int getFrequency() throws LuaException {
        if (!this.tile.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        int channel = this.getChannel();
        return TowerNetwork.getFrequency(channel);
    }

    @LuaFunction
    public final int getHeight() throws LuaException {
        if (!this.tile.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        return this.tile.getHeight();
    }
}

