/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import dan200.computercraft.api.peripheral.IPeripheral;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.peripherals.RadioPeripheral;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractRadioBlockEntity
extends BlockEntity {
    protected final Random random = new Random();
    protected int towerHeight = 1;
    protected boolean isValid = true;
    protected final RadioPeripheral peripheral = new RadioPeripheral(this);
    protected boolean initialized = false;
    protected int pingTicks = 4;
    protected long lastPing = 0L;

    public AbstractRadioBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("radio_channel")) {
            this.peripheral.setChannel(nbt.getInt("radio_channel"));
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("radio_channel", this.peripheral.getChannel());
    }

    public void setRemoved() {
        super.setRemoved();
        this.invalidate();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractRadioBlockEntity be) {
        if (!be.initialized) {
            be.initialized = true;
            be.validate();
        } else if (be.isValid) {
            long time = level.getGameTime();
            long delta = time - be.lastPing;
            if (delta == 0L) {
                be.onPing();
            } else if (delta >= (long)be.pingTicks) {
                be.afterPing();
            }
        }
    }

    public static double getSafeRange(double maxRange) {
        return maxRange - maxRange * ClassicPeripherals.CONFIG.radioTowerLossFactor;
    }

    public boolean canBroadcast() {
        return this.isValid;
    }

    public void validate() {
        this.isValid = true;
        TowerNetwork.addReceiver(this.peripheral);
    }

    public void invalidate() {
        this.isValid = false;
        TowerNetwork.removeReceiver(this.peripheral);
    }

    public void ping() {
        if (this.level != null) {
            this.lastPing = this.level.getGameTime();
        }
    }

    protected abstract void onPing();

    protected abstract void afterPing();

    public abstract BlockPos getAntennaPos();

    public int getHeight() {
        return this.towerHeight;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    public int getMaximumRange() {
        if (!this.isValid) {
            return 0;
        }
        return this.towerHeight * ClassicPeripherals.CONFIG.radioTowerSegmentRange;
    }

    public int getEffectiveMaxRange() {
        int y = this.getAntennaPos().getY();
        int range = this.getMaximumRange();
        if (y >= 96) {
            return range;
        }
        return Math.max(8, (int)(96.0 * (1.0 - Math.pow(Math.E, -0.05 * (double)y)) / 100.0 * (double)range));
    }

    public boolean inRange(AbstractRadioBlockEntity other) {
        int range = Math.max(this.getMaximumRange(), other.getMaximumRange());
        double distance = this.getAntennaPos().atY(255).distSqr((Vec3i)other.getAntennaPos().atY(255));
        return distance <= (double)(range * range);
    }

    public String flipString(String data, double percentage) {
        byte[] bytes = data.getBytes(StandardCharsets.US_ASCII);
        int total = bytes.length * 8;
        int toFlip = (int)Math.ceil((double)total * percentage);
        for (int i = 0; i < toFlip; ++i) {
            int bit = this.random.nextInt(total);
            int byteIndex = bit / 8;
            int bitIndex = bit % 8;
            int n = byteIndex;
            bytes[n] = (byte)(bytes[n] ^ (byte)(1 << bitIndex));
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

