package me.alexdevs.classicPeripherals.tiles;

import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.RfidScannerBlock;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.RfidScannerPeripheral;
import net.minecraft.class_1937;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class RfidScannerBlockEntity extends class_2586 {
    public static final int SCAN_TIME = 4;

    protected final RfidScannerPeripheral peripheral = new RfidScannerPeripheral(this);
    private long scanAt = 0;
    private boolean scheduleScan = false;

    public RfidScannerBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockTiles.RFID_SCANNER, pos, blockState);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, RfidScannerBlockEntity scanner) {
        if(level.field_9236) {
            return;
        }

        if(scanner.scheduleScan) {
            scanner.scanAt = level.method_8510() + SCAN_TIME;
            scanner.method_10997().method_8501(pos, state.method_11657(RfidScannerBlock.ACTIVE, true));
            scanner.scheduleScan = false;
        }

        if(level.method_8510() >= scanner.scanAt) {
            scanner.scan();
            scanner.method_10997().method_8501(pos, state.method_11657(RfidScannerBlock.ACTIVE, false));
        }
    }

    @Nullable
    public RfidScannerPeripheral peripheral(@Nullable class_2350 direction) {
        return direction == null || getDirection() == direction ? peripheral : null;
    }

    public class_2350 getDirection() {
        return method_11010().method_11654(class_2318.field_10927);
    }

    public void scheduleScan() {
        scheduleScan = true;
    }

    public void scan() {
        var badges = scanBadges();
        peripheral.emitScanEvent(badges);
    }

    private List<ScannedRfidBadge> scanBadges() {
        var badges = new ArrayList<ScannedRfidBadge>();

        var level = method_10997();
        var origin = peripheral.getPosition();

        if(level.field_9236)
            return List.of();

        var range = ClassicPeripherals.CONFIG.rfidScanRange;

        var nearbyPlayers = level.method_18456().stream()
                .filter(player -> player.method_19538().method_1025(origin) <= range * range)
                .map(player -> (class_3222)player)
                .toList();

        for (var player : nearbyPlayers) {
            var inventory = player.method_31548();
            for(var stack : inventory.field_7547) {
                if(!stack.method_31574(ModItems.RFID_BADGE)) {
                    continue;
                }

                var data = NfcCardItem.getData(stack);
                if(data.isEmpty()) {
                    continue;
                }

                badges.add(new ScannedRfidBadge(data.get(), player.method_19538().method_1022(origin)));
            }
        }

        return badges;
    }

    public static record ScannedRfidBadge(String data, double distance) {

    }
}
