/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.datagen;

import java.util.concurrent.CompletableFuture;
import me.alexdevs.classicPeripherals.datagen.generators.AutomaticDynamicRegistryGenerator;
import me.alexdevs.classicPeripherals.datagen.generators.LanguageGenerator;
import me.alexdevs.classicPeripherals.datagen.generators.LootTableGenerator;
import me.alexdevs.classicPeripherals.datagen.generators.ModelGenerator;
import me.alexdevs.classicPeripherals.datagen.generators.PocketUpgradeGenerator;
import me.alexdevs.classicPeripherals.datagen.generators.RecipeGenerator;
import me.alexdevs.classicPeripherals.datagen.generators.TagGenerator;
import me.alexdevs.classicPeripherals.datagen.generators.TurtleUpgradeGenerator;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7225;
import net.minecraft.class_7877;

public class ClassicPeripheralsDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ModelGenerator::new);
        pack.addProvider(RecipeGenerator::new);
        pack.addProvider(LanguageGenerator::new);
        pack.addProvider(LootTableGenerator::new);
        pack.addProvider(TagGenerator::new);
        ClassicPeripheralsDataGenerator.addPocketUpgrades(pack, fabricDataGenerator.getRegistries());
        ClassicPeripheralsDataGenerator.addTurtleUpgrades(pack, fabricDataGenerator.getRegistries());
    }

    private static void addPocketUpgrades(FabricDataGenerator.Pack pack, CompletableFuture<class_7225.class_7874> registries) {
        CompletableFuture<class_7877.class_8993> fullRegistryPatch = PocketUpgradeGenerator.makeUpgradeRegistry(registries);
        pack.addProvider(output -> new AutomaticDynamicRegistryGenerator("PocketRegistries", output, fullRegistryPatch));
    }

    private static void addTurtleUpgrades(FabricDataGenerator.Pack pack, CompletableFuture<class_7225.class_7874> registries) {
        CompletableFuture<class_7877.class_8993> fullRegistryPatch = TurtleUpgradeGenerator.makeUpgradeRegistry(registries);
        pack.addProvider(output -> new AutomaticDynamicRegistryGenerator("TurtleRegistries", output, fullRegistryPatch));
    }
}

