package me.alexdevs.classicPeripherals.block.antenna;

import me.alexdevs.classicPeripherals.block.AbstractRadioBlock;
import me.alexdevs.classicPeripherals.tiles.AbstractRadioBlockEntity;
import me.alexdevs.classicPeripherals.tiles.AntennaBlockEntity;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;


public class AntennaBlock extends AbstractRadioBlock implements class_3737 {
    public static final class_2746 ACTIVE = class_2746.method_11825("active");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    public AntennaBlock(class_2251 properties) {
        super(properties);

        method_9590(method_9595().method_11664()
                .method_11657(ACTIVE, false)
                .method_11657(WATERLOGGED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(ACTIVE, WATERLOGGED);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new AntennaBlockEntity(blockPos, blockState);
    }

    @Override
    public void method_9615(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        super.method_9615(blockState, level, blockPos, blockState2, bl);

        var be = level.method_8321(blockPos);
        if (be instanceof AntennaBlockEntity base) {
            base.validate();
        }
    }

    @Override
    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        var be = level.method_8321(blockPos);
        if (be instanceof AntennaBlockEntity base) {
            base.invalidate();
        }
        super.method_9536(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        level.method_8501(pos, state.method_11657(ACTIVE, false));
    }

    @Override
    public @NotNull class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_259.method_1081(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);
    }

    @Override
    public @NotNull class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public @NotNull class_2680 method_9559(class_2680 state, class_2350 side, class_2680 otherState, class_1936 world, class_2338 pos, class_2338 otherPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return state;
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 placement) {
        var waterlogged = placement.method_8045().method_8316(placement.method_8037()).method_15772() == class_3612.field_15910;
        return method_9564()
                .method_11657(ACTIVE, false)
                .method_11657(WATERLOGGED, waterlogged);
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.method_8608() ? null : method_31618(blockEntityType, ModBlockTiles.ANTENNA, AbstractRadioBlockEntity::tick);
    }

}
