package me.alexdevs.classicPeripherals.tiles;

import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.RfidScannerBlock;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.RfidScannerPeripheral;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class RfidScannerBlockEntity extends class_2586 {
    public static final int RANGE = 8;

    protected final RfidScannerPeripheral peripheral = new RfidScannerPeripheral(this);

    public RfidScannerBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockTiles.RFID_SCANNER, pos, blockState);
    }

    @Nullable
    public RfidScannerPeripheral peripheral(@Nullable class_2350 direction) {
        return direction == null || getDirection() == direction ? peripheral : null;
    }

    public class_2350 getDirection() {
        return method_11010().method_11654(class_2318.field_10927);
    }

    public void scheduleScan() {
        this.method_10997().method_8501(method_11016(), method_11010().method_11657(RfidScannerBlock.ACTIVE, true));
        field_11863.method_39279(method_11016(), ModBlocks.RFID_SCANNER, 2);
    }

    public void scan() {
        var badges = scanBadges();
        peripheral.emitScanEvent(badges);
    }

    private List<ScannedRfidBadge> scanBadges() {
        var badges = new ArrayList<ScannedRfidBadge>();

        var level = method_10997();
        var origin = peripheral.getPosition();

        if(level.field_9236)
            return List.of();

        var nearbyPlayers = level.method_18456().stream()
                .filter(player -> player.method_19538().method_1025(origin) <= RANGE * RANGE)
                .map(player -> (class_3222)player)
                .toList();

        for (var player : nearbyPlayers) {
            var inventory = player.method_31548();
            for(var stack : inventory.field_7547) {
                if(!stack.method_31574(ModItems.RFID_BADGE)) {
                    continue;
                }

                var data = NfcCardItem.getData(stack);
                if(data.isEmpty()) {
                    continue;
                }

                badges.add(new ScannedRfidBadge(data.get(), player.method_19538().method_1022(origin)));
            }
        }

        return badges;
    }

    public static record ScannedRfidBadge(String data, double distance) {

    }
}
