/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import dan200.computercraft.api.peripheral.IPeripheral;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.peripherals.AbstractRadioPeripheral;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jspecify.annotations.Nullable;

public abstract class AbstractRadioBlockEntity
extends class_2586 {
    protected int towerHeight = 1;
    protected boolean isValid = true;
    protected final RadioPeripheral peripheral = new RadioPeripheral(this);
    protected boolean initialized = false;
    protected int pingTicks = 4;
    protected long lastPing = 0L;

    public AbstractRadioBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        if (nbt.method_10545("radio_channel")) {
            this.peripheral.setChannel(nbt.method_10550("radio_channel"));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10569("radio_channel", this.peripheral.getChannel());
    }

    public void method_11012() {
        super.method_11012();
        this.invalidate();
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, AbstractRadioBlockEntity be) {
        if (!be.initialized) {
            be.initialized = true;
            be.validate();
        } else if (be.isValid) {
            long time = level.method_8510();
            long delta = time - be.lastPing;
            if (delta == 0L) {
                be.onPing();
            } else if (delta >= (long)be.pingTicks) {
                be.afterPing();
            }
        }
    }

    public static double getSafeRange(double maxRange) {
        return maxRange - maxRange * ClassicPeripherals.CONFIG.radioTowerLossFactor;
    }

    public boolean canBroadcast() {
        return this.isValid;
    }

    public void validate() {
        this.isValid = true;
        TowerNetwork.addReceiver(this.peripheral);
    }

    public void invalidate() {
        this.isValid = false;
        TowerNetwork.removeReceiver(this.peripheral);
    }

    public void ping() {
        if (this.field_11863 != null) {
            this.lastPing = this.field_11863.method_8510();
        }
    }

    protected abstract void onPing();

    protected abstract void afterPing();

    public abstract class_2338 getAntennaPos();

    public int getHeight() {
        return this.towerHeight;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    public int getMaximumRange() {
        if (!this.isValid) {
            return 0;
        }
        return this.towerHeight * ClassicPeripherals.CONFIG.radioTowerSegmentRange;
    }

    public int getEffectiveMaxRange() {
        int y = this.getAntennaPos().method_10264();
        int range = this.getMaximumRange();
        if (y >= 96) {
            return range;
        }
        return Math.max(8, (int)(96.0 * (1.0 - Math.pow(Math.E, -0.05 * (double)y)) / 100.0 * (double)range));
    }

    public static class RadioPeripheral
    extends AbstractRadioPeripheral {
        private final AbstractRadioBlockEntity be;

        public RadioPeripheral(AbstractRadioBlockEntity be) {
            this.be = be;
        }

        @Override
        public boolean isValid() {
            return this.be.isValid();
        }

        @Override
        public class_1937 getLevel() {
            return this.be.method_10997();
        }

        @Override
        public class_243 getPosition() {
            return class_243.method_24954((class_2382)this.be.getAntennaPos());
        }

        @Override
        public double getRange() {
            return this.be.getEffectiveMaxRange();
        }

        @Override
        public void ping() {
            this.be.ping();
        }

        @Override
        public boolean canBroadcast() {
            return this.be.canBroadcast();
        }

        @Override
        public int getHeight() {
            return this.be.getHeight();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof RadioPeripheral)) return false;
            RadioPeripheral o = (RadioPeripheral)other;
            if (this.be != o.be) return false;
            return true;
        }
    }
}

