/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import java.util.Optional;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.ModComponents;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.NfcReaderBlock;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.NfcReaderPeripheral;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;

public class NfcReaderBlockEntity
extends class_2586 {
    protected final NfcReaderPeripheral peripheral = new NfcReaderPeripheral(this);
    private boolean writeMode = false;
    private String pendingWriteData = "";
    private @Nullable String pendingLabel = null;
    private boolean pendingReadOnly = false;

    public NfcReaderBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockTiles.NFC_READER, pos, blockState);
    }

    public NfcReaderPeripheral peripheral() {
        return this.peripheral;
    }

    public void flagWrite(String data, @Nullable String label, Boolean flagReadOnly) {
        int maxDataSize = ClassicPeripherals.CONFIG.nfcMaxDataSize;
        this.writeMode = true;
        this.pendingWriteData = data.substring(0, Math.min(data.length(), maxDataSize));
        this.pendingLabel = label;
        this.pendingReadOnly = flagReadOnly;
        this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.WRITING)));
    }

    public void cancelWrite() {
        this.writeMode = false;
        this.pendingWriteData = "";
        this.pendingLabel = null;
        this.pendingReadOnly = false;
        this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.NONE)));
    }

    public boolean isWriteMode() {
        return this.writeMode;
    }

    public void pingRead() {
        this.method_10997().method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.READING)));
        this.field_11863.method_39279(this.method_11016(), (class_2248)ModBlocks.NFC_READER, 10);
    }

    public void onUse(class_1799 stack) {
        if (this.writeMode) {
            class_9323 components = stack.method_57353();
            Boolean readOnly = (Boolean)components.method_57830(ModComponents.NFC_READONLY, (Object)false);
            if (readOnly.booleanValue()) {
                this.peripheral.writeFeedback(false, "read_only");
                this.cancelWrite();
                return;
            }
            class_9323.class_9324 mapBuilder = class_9323.method_57827();
            if (this.pendingLabel != null) {
                mapBuilder.method_57840(class_9334.field_49631, (Object)class_2561.method_43470((String)this.pendingLabel));
            } else {
                stack.method_57381(class_9334.field_49631);
            }
            mapBuilder.method_57840(ModComponents.NFC_DATA, (Object)this.pendingWriteData);
            mapBuilder.method_57840(ModComponents.NFC_READONLY, (Object)this.pendingReadOnly);
            stack.method_57365(mapBuilder.method_57838());
            this.peripheral.writeFeedback(true, "success");
            this.cancelWrite();
        } else {
            Optional<String> data = NfcCardItem.getData(stack);
            if (data.isPresent()) {
                this.peripheral.read(data.get());
                this.pingRead();
            }
        }
    }
}

