/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.AbstractMachineTerminalScreen;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.terminal.TerminalInput;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.vm.terminal.Terminal;
import li.cil.oc2.common.vm.terminal.modes.MouseMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector2i;

@OnlyIn(value=Dist.CLIENT)
public final class MachineTerminalWidget {
    private static final int TERMINAL_WIDTH = 320;
    private static final int TERMINAL_HEIGHT = 192;
    private static final int MARGIN_SIZE = 8;
    private static final int TERMINAL_X = 8;
    private static final int TERMINAL_Y = 8;
    public static final int WIDTH = Sprites.TERMINAL_SCREEN.width;
    public static final int HEIGHT = Sprites.TERMINAL_SCREEN.height;
    private final AbstractMachineTerminalScreen<?> parent;
    private final AbstractMachineTerminalContainer container;
    private final Terminal terminal;
    private int leftPos;
    private int topPos;
    private boolean isMouseOverTerminal;
    private Terminal.RendererView rendererView;
    private boolean isOver;

    public MachineTerminalWidget(AbstractMachineTerminalScreen<?> parent) {
        this.parent = parent;
        this.container = (AbstractMachineTerminalContainer)this.parent.m_6262_();
        this.terminal = this.container.getTerminal();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.isMouseOverTerminal = this.isMouseOverTerminal(mouseX, mouseY);
        Sprites.TERMINAL_SCREEN.draw(graphics, this.leftPos, this.topPos);
        if (this.shouldCaptureInput()) {
            Sprites.TERMINAL_FOCUSED.draw(graphics, this.leftPos, this.topPos);
        }
    }

    public void render(GuiGraphics graphics, @Nullable Component error) {
        if (this.container.getVirtualMachine().isRunning()) {
            PoseStack terminalStack = new PoseStack();
            terminalStack.m_252880_((float)(this.leftPos + 8), (float)(this.topPos + 8), 0.0f);
            terminalStack.m_85841_(320.0f / (float)this.terminal.getWidth(), 192.0f / (float)this.terminal.getHeight(), 1.0f);
            if (this.rendererView == null) {
                this.rendererView = this.terminal.getRenderer();
            }
            Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)this.parent.f_96543_, (float)this.parent.f_96544_, 0.0f, -10.0f, 10.0f);
            this.rendererView.render(terminalStack, projectionMatrix);
        } else {
            Font font = this.getClient().f_91062_;
            if (error != null) {
                int textWidth = font.m_92852_((FormattedText)error);
                int textOffsetX = (320 - textWidth) / 2;
                Objects.requireNonNull(font);
                int textOffsetY = (192 - 9) / 2;
                this.drawShadow(font, graphics, error, this.leftPos + 8 + textOffsetX, this.topPos + 8 + textOffsetY);
            }
        }
    }

    private void drawShadow(Font font, GuiGraphics graphics, Component text, float x, float y) {
        MultiBufferSource.BufferSource batch = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_272077_(text, x, y, 0xEE3322, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)batch, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        batch.m_109911_();
    }

    public void tick() {
        ByteBuffer input = this.terminal.getInput();
        if (input != null) {
            this.container.sendTerminalInputToServer(input);
        }
    }

    public boolean mouseScrolled(double dir) {
        if (this.terminal.currentPrivateModeState.isAltBufferEnabled()) {
            return false;
        }
        if (dir < 0.0) {
            this.terminal.incrementLastLineToDisplay(true);
        } else {
            this.terminal.decrementLastLineToDisplay();
        }
        return true;
    }

    public void mouseMoved(double x, double y) {
        if (this.isMouseOverTerminal((int)x, (int)y)) {
            if (!this.isOver && this.terminal.currentPrivateModeState.FOCUS_IN_FOCUS_OUT) {
                this.isOver = true;
                this.terminal.putInput("\u001b[I");
            }
        } else if (this.isOver && this.terminal.currentPrivateModeState.FOCUS_IN_FOCUS_OUT) {
            this.terminal.putInput("\u001b[O");
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        MouseMode currentMouseMode = this.terminal.currentPrivateModeState.getMouseMode();
        if (currentMouseMode.isMouseDisabled()) {
            return false;
        }
        Vector2i position = this.getMousePosition(x, y);
        boolean overTerminal = this.isMouseOverTerminal((int)x, (int)y);
        if (overTerminal && this.shouldCaptureInput()) {
            switch (currentMouseMode.PrimaryMode) {
                case 1000: 
                case 1002: {
                    if (currentMouseMode.isSecondaryModeEnabled(1006)) {
                        this.terminal.putInput("\u001b[<" + button + ";" + position.x + ";" + position.y + "M");
                        return true;
                    }
                    if (currentMouseMode.isSecondaryModeEnabled(1005)) {
                        byte[] csiMBytes = "\u001b[M".getBytes(StandardCharsets.UTF_8);
                        byte[] buttonBytes = this.utf8(button + 32);
                        byte[] colBytes = this.utf8(position.x + 32);
                        byte[] rowBytes = this.utf8(position.y + 32);
                        byte[] finalBytes = new byte[csiMBytes.length + buttonBytes.length + colBytes.length + rowBytes.length];
                        System.arraycopy(csiMBytes, 0, finalBytes, 0, csiMBytes.length);
                        System.arraycopy(buttonBytes, 0, finalBytes, csiMBytes.length, buttonBytes.length);
                        System.arraycopy(colBytes, 0, finalBytes, csiMBytes.length + buttonBytes.length, colBytes.length);
                        System.arraycopy(rowBytes, 0, finalBytes, csiMBytes.length + buttonBytes.length + colBytes.length, rowBytes.length);
                        this.terminal.putInput(ByteBuffer.wrap(finalBytes));
                        return true;
                    }
                    if (currentMouseMode.isSecondaryModeEnabled(1015)) {
                        this.terminal.putInput("\u001b[" + (button + 32) + ";" + position.x + ";" + position.y + "M");
                        break;
                    }
                    this.terminal.putInput('\u001b');
                    this.terminal.putInput('[');
                    this.terminal.putInput('M');
                    this.terminal.putInput((byte)(button + 32));
                    this.terminal.putInput((byte)(position.x + 32));
                    this.terminal.putInput((byte)(position.y + 32));
                    return true;
                }
                default: {
                    System.out.println("ERR: Unsupported primary mode");
                }
            }
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        MouseMode currentMouseMode = this.terminal.currentPrivateModeState.getMouseMode();
        if (currentMouseMode.isMouseDisabled()) {
            return false;
        }
        Vector2i position = this.getMousePosition(x, y);
        boolean overTerminal = this.isMouseOverTerminal((int)x, (int)y);
        if (overTerminal && this.shouldCaptureInput()) {
            switch (currentMouseMode.PrimaryMode) {
                case 1000: 
                case 1002: {
                    if (currentMouseMode.isSecondaryModeEnabled(1006)) {
                        this.terminal.putInput("\u001b[<" + button + ";" + position.x + ";" + position.y + "m");
                        return true;
                    }
                    if (currentMouseMode.isSecondaryModeEnabled(1005)) {
                        byte[] csiMBytes = "\u001b[M".getBytes(StandardCharsets.UTF_8);
                        byte[] buttonBytes = this.utf8(35);
                        byte[] colBytes = this.utf8(position.x + 32);
                        byte[] rowBytes = this.utf8(position.y + 32);
                        byte[] finalBytes = new byte[csiMBytes.length + buttonBytes.length + colBytes.length + rowBytes.length];
                        System.arraycopy(csiMBytes, 0, finalBytes, 0, csiMBytes.length);
                        System.arraycopy(buttonBytes, 0, finalBytes, csiMBytes.length, buttonBytes.length);
                        System.arraycopy(colBytes, 0, finalBytes, csiMBytes.length + buttonBytes.length, colBytes.length);
                        System.arraycopy(rowBytes, 0, finalBytes, csiMBytes.length + buttonBytes.length + colBytes.length, rowBytes.length);
                        this.terminal.putInput(ByteBuffer.wrap(finalBytes));
                        return true;
                    }
                    if (currentMouseMode.isSecondaryModeEnabled(1015)) {
                        this.terminal.putInput("\u001b[35;" + position.x + ";" + position.y + "M");
                        break;
                    }
                    this.terminal.putInput('\u001b');
                    this.terminal.putInput('[');
                    this.terminal.putInput('M');
                    this.terminal.putInput((byte)35);
                    this.terminal.putInput((byte)(position.x + 32));
                    this.terminal.putInput((byte)(position.y + 32));
                    return true;
                }
                default: {
                    System.out.println("ERR: Unsupported primary mode");
                }
            }
        }
        return false;
    }

    private byte[] utf8(int value) {
        return new String(new int[]{value}, 0, 1).getBytes(StandardCharsets.UTF_8);
    }

    private Vector2i getMousePosition(double x, double y) {
        int tx = 4;
        int ty = 8;
        int sx = (int)((x - (double)this.leftPos - 8.0) / (double)tx) + 1;
        int sy = (int)((y - (double)this.topPos - 8.0) / (double)ty) + 1;
        return new Vector2i(sx, sy);
    }

    public boolean charTyped(char ch, int modifier) {
        if (modifier == 0 || modifier == 1) {
            this.terminal.putInput((byte)ch);
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.shouldCaptureInput() && keyCode == 256) {
            return false;
        }
        if (keyCode == 256 && this.terminal.currentPrivateModeState.APPLICATION_ESC_MODE) {
            this.terminal.putInput("\u001b[0[");
        }
        if ((modifiers & 2) != 0 && keyCode == 86) {
            String value = this.getClient().f_91068_.m_90876_();
            boolean bracketed = this.terminal.currentPrivateModeState.SET_BRACKETED_PASTE;
            if (bracketed) {
                this.terminal.putInput("\u001b[200~");
            }
            for (char ch : value.toCharArray()) {
                this.terminal.putInput((byte)ch);
            }
            if (bracketed) {
                this.terminal.putInput("\u001b[201~");
            }
        } else {
            byte[] sequence = this.terminal.currentPrivateModeState.DECCKM && (keyCode == 265 || keyCode == 264 || keyCode == 263 || keyCode == 262) ? TerminalInput.getDECCKMSequence(keyCode, modifiers) : TerminalInput.getSequence(keyCode, modifiers);
            if (sequence != null) {
                for (byte b : sequence) {
                    this.terminal.putInput(b);
                }
            }
        }
        return true;
    }

    public void init() {
        this.leftPos = (this.parent.f_96543_ - WIDTH) / 2;
        this.topPos = (this.parent.f_96544_ - HEIGHT) / 2;
    }

    public void onClose() {
        if (this.rendererView != null) {
            this.terminal.releaseRenderer(this.rendererView);
            this.rendererView = null;
        }
    }

    private Minecraft getClient() {
        return this.parent.getMinecraft();
    }

    private boolean shouldCaptureInput() {
        return this.isMouseOverTerminal && this.container.getCaptureInputState() && this.container.getVirtualMachine().isRunning();
    }

    private boolean isMouseOverTerminal(int mouseX, int mouseY) {
        return this.parent.isMouseOver(mouseX, mouseY, 8, 8, 320, 192);
    }
}

