/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.config.common;

import li.cil.oc2.common.config.Config;
import net.minecraftforge.common.ForgeConfigSpec;

public class VXLANSpec {
    public final ForgeConfigSpec.BooleanValue enable;
    public final ForgeConfigSpec.ConfigValue<String> remoteHost;
    public final ForgeConfigSpec.IntValue remotePort;
    public final ForgeConfigSpec.ConfigValue<String> bindHost;
    public final ForgeConfigSpec.IntValue bindPort;

    VXLANSpec(ForgeConfigSpec.Builder builder) {
        this.enable = builder.comment("Whether to enable VXLAN support, must be on for the internet card to work").define("enable", false);
        this.remoteHost = builder.comment("The remote host that the VXLAN protocol is running on").define("remoteHost", (Object)"::1");
        this.remotePort = builder.comment("The remote port that the VXLAN protocol is exposed on").defineInRange("remotePort", 4789, 1, 65535);
        this.bindHost = builder.comment("The address to bind VXLAN to").define("bindHost", (Object)"::1");
        this.bindPort = builder.comment("The port to bind VXLAN to").defineInRange("bindPort", 4789, 1, 65535);
    }

    public void loadValues() {
        Config.enable = (Boolean)this.enable.get();
        Config.remoteHost = (String)this.remoteHost.get();
        Config.remotePort = (Integer)this.remotePort.get();
        Config.bindHost = (String)this.bindHost.get();
        Config.bindPort = (Integer)this.bindPort.get();
    }
}

