/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import li.cil.oc2.api.inet.InternetManager;
import li.cil.oc2.api.inet.layer.LinkLocalLayer;
import li.cil.oc2.api.inet.provider.InternetProvider;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.inet.DefaultInternetProvider;
import li.cil.oc2.common.inet.InetUtils;
import li.cil.oc2.common.inet.InternetAdapter;
import li.cil.oc2.common.inet.InternetConnection;
import li.cil.oc2.common.inet.Ipv4Space;
import li.cil.oc2.common.inet.LayerParametersImpl;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class InternetManagerImpl
implements InternetManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static InternetManagerImpl INSTANCE = null;
    private final InternetProvider internetProvider;
    private final List<InternetConnectionImpl> connections = new LinkedList<InternetConnectionImpl>();
    private final List<TaskImpl> tasks = new LinkedList<TaskImpl>();
    private final ExecutorService executor;
    private final Ipv4Space ipSpace;

    private InternetManagerImpl() {
        ServiceLoader<InternetProvider> serviceLoader = ServiceLoader.load(InternetProvider.class);
        Iterator<InternetProvider> iterator = serviceLoader.iterator();
        this.internetProvider = iterator.hasNext() ? iterator.next() : DefaultInternetProvider.INSTANCE;
        this.executor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "Internet"));
        this.ipSpace = InetUtils.computeIpSpace(Config.deniedHosts, Config.allowedHosts);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void initialize() {
        if (!Config.internetCardEnabled) {
            LOGGER.info("Internet card is disabled; Internet manager will not start");
        } else {
            INSTANCE = new InternetManagerImpl();
            LOGGER.warn("Internet card is enabled; Players may access to the internal network");
        }
    }

    public static Optional<InternetManagerImpl> getInstance() {
        return Optional.ofNullable(INSTANCE);
    }

    @Override
    public InternetManager.Task runOnInternetThreadTick(Runnable action) {
        TaskImpl task = new TaskImpl(action);
        this.tasks.add(task);
        return task;
    }

    public InternetConnection connect(InternetAdapter internetAdapter, @Nullable Tag savedState) {
        LayerParametersImpl layerParameters = new LayerParametersImpl(Optional.ofNullable(savedState), this);
        InternetConnectionImpl internetConnection = new InternetConnectionImpl(internetAdapter, this.internetProvider.provideInternet(layerParameters));
        this.connections.add(internetConnection);
        LOGGER.debug("A new internet access provided");
        return internetConnection;
    }

    private void processInternetAdapter(InternetConnectionImpl connection) {
        byte[] sending;
        InternetAdapter adapter = connection.adapter;
        byte[] received = connection.incoming.get();
        if (received != null) {
            adapter.sendEthernetFrame(received);
        }
        if ((sending = adapter.receiveEthernetFrame()) != null) {
            connection.outcoming.put(sending);
        }
    }

    public boolean isAllowedToConnect(int ipAddress) {
        return this.ipSpace.isAllowed(ipAddress);
    }

    private void runTasks() {
        this.tasks.removeIf(task -> {
            if (task.isClosed()) {
                return true;
            }
            Runnable action = task.getAction();
            try {
                action.run();
                return false;
            }
            catch (Exception exception) {
                LOGGER.error("Uncaught exception while running internet thread task; this task removed from schedule", (Throwable)exception);
                return true;
            }
        });
    }

    private void runOnInternetThread(List<InternetConnectionImpl> connectionsToStop, List<InternetConnectionImpl> connectionsToProcess) {
        this.runTasks();
        connectionsToStop.forEach(connection -> {
            LOGGER.debug("Revoked internet access");
            connection.ethernet.onStop();
        });
        connectionsToProcess.forEach(InternetConnectionImpl::process);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        List connectionsToStop = this.connections.stream().filter(connection -> connection.isStopped).collect(Collectors.toList());
        List connectionsToProcess = this.connections.stream().filter(connection -> !connection.isStopped).collect(Collectors.toList());
        this.connections.removeIf(connection -> {
            if (connection.isStopped) {
                return true;
            }
            this.processInternetAdapter((InternetConnectionImpl)connection);
            return false;
        });
        this.executor.execute(() -> this.runOnInternetThread(connectionsToStop, connectionsToProcess));
    }

    @SubscribeEvent
    public void onStopping(ServerStoppingEvent event) {
        this.connections.clear();
    }

    private static final class TaskImpl
    implements InternetManager.Task {
        private final Runnable action;
        private boolean closed = false;

        public TaskImpl(Runnable action) {
            this.action = action;
        }

        public Runnable getAction() {
            return this.action;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private final class InternetConnectionImpl
    implements InternetConnection {
        public final PendingFrame incoming = new PendingFrame();
        public final PendingFrame outcoming = new PendingFrame();
        private final ByteBuffer receiveBuffer = ByteBuffer.allocate(1514);
        private final LinkLocalLayer ethernet;
        private final InternetAdapter adapter;
        private boolean isStopped = false;

        public InternetConnectionImpl(InternetAdapter adapter, LinkLocalLayer ethernet) {
            this.adapter = adapter;
            this.ethernet = ethernet;
        }

        @Override
        public Optional<Tag> saveAdapterState() {
            try {
                return InternetManagerImpl.this.executor.submit(this.ethernet::onSave).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                LOGGER.error("Error on saving internet adapter state", (Throwable)exception);
                return Optional.empty();
            }
        }

        public void process() {
            try {
                byte[] outFrame = this.outcoming.get();
                if (outFrame != null) {
                    this.ethernet.sendEthernetFrame(ByteBuffer.wrap(outFrame));
                }
                this.receiveBuffer.clear();
                if (this.ethernet.receiveEthernetFrame(this.receiveBuffer)) {
                    byte[] inFrame = new byte[this.receiveBuffer.remaining()];
                    this.receiveBuffer.get(inFrame);
                    this.incoming.put(inFrame);
                }
            }
            catch (Exception e) {
                LOGGER.error("Uncaught exception", (Throwable)e);
            }
        }

        @Override
        public void stop() {
            this.isStopped = true;
        }

        private static final class PendingFrame {
            private final AtomicReference<byte[]> pendingFrame = new AtomicReference();

            private PendingFrame() {
            }

            @Nullable
            public byte[] get() {
                return this.pendingFrame.getAndSet(null);
            }

            public void put(byte[] frame) {
                this.pendingFrame.set(frame);
            }
        }
    }
}

