/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import li.cil.oc2.common.container.NetworkTunnelContainer;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.TextFormatUtils;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class NetworkTunnelItem
extends ModItem {
    private static final String TUNNEL_ID_TAG_NAME = "tunnel";
    private static final String TUNNEL_ID_TEXT = TranslationUtils.key("tooltip.{mod}.network_tunnel_id");

    public NetworkTunnelItem() {
        super(NetworkTunnelItem.createProperties().m_41487_(1));
    }

    public static Optional<UUID> getTunnelId(ItemStack stack) {
        CompoundTag tag = ItemStackUtils.getModDataTag(stack);
        if (tag.m_128403_(TUNNEL_ID_TAG_NAME)) {
            return Optional.of(tag.m_128342_(TUNNEL_ID_TAG_NAME));
        }
        return Optional.empty();
    }

    public static void setTunnelId(ItemStack stack, UUID value) {
        ItemStackUtils.getOrCreateModDataTag(stack).m_128362_(TUNNEL_ID_TAG_NAME, value);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        NetworkTunnelItem.getTunnelId(stack).ifPresent(id -> {
            String idString = StringUtil.m_144998_((String)id.toString(), (int)11, (boolean)true);
            MutableComponent idComponent = TextFormatUtils.withFormat(idString, ChatFormatting.GREEN);
            tooltip.add((Component)Component.m_237110_((String)TUNNEL_ID_TEXT, (Object[])new Object[]{idComponent}).m_130940_(ChatFormatting.GRAY));
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openContainerScreen(serverPlayer, hand);
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    private void openContainerScreen(ServerPlayer player, InteractionHand hand) {
        NetworkTunnelContainer.createServer(player, hand);
    }
}

