/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.provider;

import java.util.Optional;
import li.cil.oc2.common.vm.device.SimpleFramebufferDevice;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.devicetree.DeviceTreeProvider;
import li.cil.sedna.api.memory.MemoryMap;

public final class SimpleFramebufferDeviceProvider
implements DeviceTreeProvider {
    public Optional<String> getName(Device device) {
        return Optional.of("framebuffer");
    }

    public Optional<DeviceTree> createNode(DeviceTree root, MemoryMap memoryMap, Device device, String deviceName) {
        Optional range = memoryMap.getMemoryRange((MemoryMappedDevice)device);
        return range.map(r -> {
            DeviceTree chosen = root.find("/chosen");
            chosen.addProp("ranges", new Object[0]);
            return chosen.getChild(deviceName, r.address());
        });
    }

    public void visit(DeviceTree node, MemoryMap memoryMap, Device device) {
        SimpleFramebufferDevice fb = (SimpleFramebufferDevice)device;
        node.addProp("compatible", new Object[]{"simple-framebuffer"}).addProp("width", new Object[]{fb.getWidth()}).addProp("height", new Object[]{fb.getHeight()}).addProp("stride", new Object[]{fb.getWidth() * 2}).addProp("format", new Object[]{"r5g6b5"}).addProp("no-map", new Object[0]).addProp("status", new Object[]{"okay"});
    }
}

