/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.escapes.csi;

import java.util.Arrays;
import li.cil.oc2.common.vm.terminal.Terminal;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSISequenceHandler;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSIState;

public class CH10
extends CSISequenceHandler {
    public CH10(Terminal terminal) {
        super(terminal);
    }

    @Override
    public void execute(int[] args, int argsCount, CSIState state) {
        if (state.hash) {
            System.out.println("XTPUSHCOLORS not implemented");
        } else {
            int chars = Math.min(Math.max(args[0], 1), 80 - this.terminal.x);
            int startIndex = (this.terminal.currentPrivateModeState.isAltBufferEnabled() ? this.terminal.y * 80 : (this.terminal.y + (this.terminal.lastRowToDisplayMax - 24)) * 80) + this.terminal.x;
            int count = 80 - this.terminal.x - chars;
            int endIndex = startIndex + count;
            Terminal.ColorData c = switch (this.terminal.currentBackgroundColorMode) {
                case Terminal.ColorMode.SIXTEEN_COLOR -> this.terminal.sixteenColor;
                case Terminal.ColorMode.TWO_FIFTY_SIX_COLOR -> this.terminal.twoFiftySixColor;
                case Terminal.ColorMode.TRUE_COLOR -> this.terminal.backgroundColor;
                case Terminal.ColorMode.SIXTEEN_COLOR_BRIGHT -> this.terminal.sixteenColorBright;
                default -> Terminal.DEFAULT_BACKGROUND_COLOR;
            };
            if (this.terminal.currentPrivateModeState.isAltBufferEnabled()) {
                System.arraycopy(this.terminal.altBuffer, startIndex + chars, this.terminal.altBuffer, startIndex, count);
                System.arraycopy(this.terminal.altColors, startIndex + chars, this.terminal.altColors, startIndex, count);
                System.arraycopy(this.terminal.altColorsBackground, startIndex + chars, this.terminal.altColorsBackground, startIndex, count);
                System.arraycopy(this.terminal.altStyles, startIndex + chars, this.terminal.altStyles, startIndex, count);
                Arrays.fill(this.terminal.altBuffer, endIndex, endIndex + chars + 1, 32);
                Arrays.fill(this.terminal.altColors, endIndex, endIndex + chars + 1, Terminal.DEFAULT_COLORS.Copy());
                Arrays.fill(this.terminal.altColorsBackground, endIndex, endIndex + chars + 1, c.Copy());
                Arrays.fill(this.terminal.altStyles, endIndex, endIndex + chars + 1, (byte)0);
            } else {
                System.arraycopy(this.terminal.buffer, startIndex + chars, this.terminal.buffer, startIndex, count);
                System.arraycopy(this.terminal.colors, startIndex + chars, this.terminal.colors, startIndex, count);
                System.arraycopy(this.terminal.colorsBackground, startIndex + chars, this.terminal.colorsBackground, startIndex, count);
                System.arraycopy(this.terminal.styles, startIndex + chars, this.terminal.styles, startIndex, count);
                Arrays.fill(this.terminal.buffer, endIndex, endIndex + chars + 1, 32);
                Arrays.fill(this.terminal.colors, endIndex, endIndex + chars + 1, Terminal.DEFAULT_COLORS.Copy());
                Arrays.fill(this.terminal.colorsBackground, endIndex, endIndex + chars + 1, c.Copy());
                Arrays.fill(this.terminal.styles, endIndex, endIndex + chars + 1, (byte)0);
            }
            this.terminal.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << this.terminal.y, (left, right) -> left | right));
        }
    }
}

