/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.api.inet;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import li.cil.oc2.common.inet.InetUtils;

public final class TransportMessage {
    private static final byte DEFAULT_TTL = 64;
    private short networkProtocolNumber = (short)-1;
    private long srcIpAddressMost = -1L;
    private long srcIpAddressLeast = -1L;
    private long dstIpAddressMost = -1L;
    private long dstIpAddressLeast = -1L;
    private byte ttl = (byte)-1;
    private ByteBuffer data = null;

    public void initializeBuffer(ByteBuffer data) {
        this.data = data;
    }

    public void update(short networkProtocolNumber, long srcIpAddressMost, long srcIpAddressLeast, long dstIpAddressMost, long dstIpAddressLeast, byte ttl) {
        this.networkProtocolNumber = networkProtocolNumber;
        this.srcIpAddressMost = srcIpAddressMost;
        this.srcIpAddressLeast = srcIpAddressLeast;
        this.dstIpAddressMost = dstIpAddressMost;
        this.dstIpAddressLeast = dstIpAddressLeast;
        this.ttl = ttl;
    }

    public void updateIpv4(int srcIpAddress, int dstIpAddress, byte ttl) {
        this.update((short)2048, 0L, srcIpAddress, 0L, dstIpAddress, ttl);
    }

    public void updateIpv4(int srcIpAddress, int dstIpAddress) {
        this.updateIpv4(srcIpAddress, dstIpAddress, (byte)64);
    }

    public byte getTtl() {
        return this.ttl;
    }

    public int getSrcIpv4Address() {
        return (int)this.srcIpAddressLeast;
    }

    public int getDstIpv4Address() {
        return (int)this.dstIpAddressLeast;
    }

    public InetAddress getSrcAddress() {
        return switch (this.networkProtocolNumber) {
            case 2048 -> InetUtils.toJavaInetAddress(this.getSrcIpv4Address());
            case -31011 -> InetUtils.toJavaInetAddress(this.srcIpAddressMost, this.srcIpAddressLeast);
            default -> throw new IllegalStateException();
        };
    }

    public InetAddress getDstAddress() {
        return switch (this.networkProtocolNumber) {
            case 2048 -> InetUtils.toJavaInetAddress(this.getDstIpv4Address());
            case -31011 -> InetUtils.toJavaInetAddress(this.dstIpAddressMost, this.dstIpAddressLeast);
            default -> throw new IllegalStateException();
        };
    }

    public ByteBuffer getData() {
        if (this.data == null) {
            throw new IllegalStateException();
        }
        return this.data;
    }

    public short getNetworkProtocolNumber() {
        return this.networkProtocolNumber;
    }

    public boolean isIpv4() {
        return this.networkProtocolNumber == 2048;
    }

    public boolean isIpv6() {
        return this.networkProtocolNumber == -31011;
    }
}

