/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.item;

import li.cil.oc2.common.item.Items;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class CustomItemColors {
    public static final int BLACK = -12566464;
    public static final int GREY = -11184811;
    public static final int LIGHT_GREY = -7763575;
    public static final int WHITE = -3487030;
    public static final int LIME = -10102229;
    public static final int GREEN = -14902223;
    public static final int CYAN = -15612483;
    public static final int BLUE = -11573528;
    public static final int LIGHT_BLUE = -15625531;
    public static final int PURPLE = -7404854;
    public static final int MAGENTA = -3796857;
    public static final int PINK = -2403907;
    public static final int ORANGE = -2260931;
    public static final int RED = -2278083;
    public static final int BROWN = -9151422;
    public static final int YELLOW = -951;
    private static final int NO_TINT = -1;

    public static void initialize() {
        ItemColors itemColors = Minecraft.m_91087_().getItemColors();
        itemColors.m_92689_((stack, layer) -> layer == 1 ? CustomItemColors.getColor(stack) : -1, new ItemLike[]{(ItemLike)Items.HARD_DRIVE_SMALL.get(), (ItemLike)Items.HARD_DRIVE_MEDIUM.get(), (ItemLike)Items.HARD_DRIVE_LARGE.get(), (ItemLike)Items.HARD_DRIVE_EXTRA_LARGE.get(), (ItemLike)Items.FLOPPY.get(), (ItemLike)Items.FLOPPY_MODERN.get()});
    }

    public static int getColorByDye(DyeColor dye) {
        return switch (dye) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> -3487030;
            case DyeColor.ORANGE -> -2260931;
            case DyeColor.MAGENTA -> -3796857;
            case DyeColor.LIGHT_BLUE -> -15625531;
            case DyeColor.YELLOW -> -951;
            case DyeColor.LIME -> -10102229;
            case DyeColor.PINK -> -2403907;
            case DyeColor.GRAY -> -11184811;
            case DyeColor.LIGHT_GRAY -> -7763575;
            case DyeColor.CYAN -> -15612483;
            case DyeColor.PURPLE -> -7404854;
            case DyeColor.BLUE -> -11573528;
            case DyeColor.BROWN -> -9151422;
            case DyeColor.GREEN -> -14902223;
            case DyeColor.RED -> -2278083;
            case DyeColor.BLACK -> -12566464;
        };
    }

    public static int getColor(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            DyeableLeatherItem coloredItem = (DyeableLeatherItem)item;
            return coloredItem.m_41121_(stack);
        }
        return -11184811;
    }

    public static ItemStack withColor(ItemStack stack, DyeColor color) {
        return CustomItemColors.withColor(stack, CustomItemColors.getColorByDye(color));
    }

    public static ItemStack withColor(ItemStack stack, int color) {
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            DyeableLeatherItem coloredItem = (DyeableLeatherItem)item;
            coloredItem.m_41115_(stack, color);
        }
        return stack;
    }
}

