/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import li.cil.oc2.client.renderer.ModRenderType;
import li.cil.oc2.common.blockentity.InternetGateWayBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import org.joml.Matrix4f;

public class InternetGateWayRenderer
implements BlockEntityRenderer<InternetGateWayBlockEntity> {
    private static final float BLOCK_HEIGHT = 0.875f;
    private static final float PORTAL_POSITION = 0.4f;
    private static final float EMITTER_POSITION = -0.1875f;
    private static final float EMITTER_SIZE = 0.375f;
    private static final float EMITTER_PIXEL_SIZE = 0.041666668f;
    private static final int[] SCRAMBLER = new int[]{1, 2, 0, 3, 13, 5, 15, 12, 6, 14, 10, 11, 7, 8, 9, 4};

    public InternetGateWayRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(InternetGateWayBlockEntity gateWay, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        int scrambledPointer;
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.875f, 0.5f);
        stack.m_85836_();
        long time = System.currentTimeMillis();
        long dt = time - gateWay.lastRender;
        gateWay.lastRender = time;
        if (dt > 1000L) {
            gateWay.handledInboundCount = gateWay.inboundCount;
            gateWay.handledOutboundCount = gateWay.outboundCount;
        }
        double phase = (double)time / 1000.0;
        stack.m_85837_(0.0, (double)0.4f + Math.sin(phase / 2.0) * (double)0.03f, 0.0);
        VertexConsumer portal = bufferSource.m_6299_(RenderType.m_173239_());
        Matrix4f matrix = stack.m_85850_().m_252922_();
        float halfSide = 0.2f;
        this.renderCube(portal, matrix, halfSide, 0.0f, 0.0f, 0.0f, false);
        stack.m_85849_();
        stack.m_252880_(0.0f, -0.1875f, 0.0f);
        matrix = stack.m_85850_().m_252922_();
        int pendingPackets = Math.max(0, gateWay.inboundCount - gateWay.handledInboundCount) + Math.max(0, gateWay.outboundCount - gateWay.handledOutboundCount);
        float speedMod = Math.max(1.0f, Math.min(1.5f, (float)pendingPackets * 0.025f));
        VertexConsumer packet = bufferSource.m_6299_(ModRenderType.getGateWayParticle());
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                int flatPos = x * 4 + z;
                if (!(gateWay.animProgress[flatPos] < 1.0f)) continue;
                float animPos = gateWay.animProgress[flatPos];
                int n = flatPos;
                gateWay.animProgress[n] = gateWay.animProgress[n] + (float)dt / 1000.0f * speedMod;
                if (gateWay.animReversed[flatPos]) {
                    animPos = 1.0f - animPos;
                }
                this.renderCube(packet, matrix, 0.020833334f, ((float)(x * 2) - 3.0f) * 0.041666668f, animPos * 0.5875f, ((float)(z * 2) - 3.0f) * 0.041666668f, true);
            }
        }
        while ((gateWay.handledInboundCount < gateWay.inboundCount || gateWay.handledOutboundCount < gateWay.outboundCount) && gateWay.animProgress[scrambledPointer = SCRAMBLER[gateWay.pointer]] >= 1.0f) {
            ++gateWay.pointer;
            if (gateWay.pointer >= 16) {
                gateWay.pointer = 0;
            }
            gateWay.animProgress[scrambledPointer] = 0.0f - (float)Math.random() * 0.1f;
            if (gateWay.handledInboundCount < gateWay.inboundCount) {
                gateWay.animReversed[scrambledPointer] = true;
                ++gateWay.handledInboundCount;
                continue;
            }
            gateWay.animReversed[scrambledPointer] = false;
            ++gateWay.handledOutboundCount;
        }
        stack.m_85849_();
    }

    private void renderCube(VertexConsumer vertices, Matrix4f matrix, float halfSide, float x, float y, float z, boolean enColor) {
        this.renderCubeFace(vertices, matrix, halfSide + x, 0.0f + y, 0.0f + z, halfSide, 5, 1, 0, enColor);
        this.renderCubeFace(vertices, matrix, -halfSide + x, 0.0f + y, 0.0f + z, halfSide, 5, 0, 1, enColor);
        this.renderCubeFace(vertices, matrix, 0.0f + x, halfSide + y, 0.0f + z, halfSide, 0, 5, 1, enColor);
        this.renderCubeFace(vertices, matrix, 0.0f + x, -halfSide + y, 0.0f + z, halfSide, 1, 5, 0, enColor);
        this.renderCubeFace(vertices, matrix, 0.0f + x, 0.0f + y, -halfSide + z, halfSide, 0, 1, 5, enColor);
        this.renderCubeFace(vertices, matrix, 0.0f + x, 0.0f + y, halfSide + z, halfSide, 1, 0, 5, enColor);
    }

    private void renderCubeFace(VertexConsumer vertices, Matrix4f matrix, float x, float y, float z, float halfSideSize, int signShiftX, int signShiftY, int signShiftZ, boolean enColor) {
        float[] signs = new float[]{-1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        for (int i = 0; i < 4; ++i) {
            vertices.m_252986_(matrix, x + halfSideSize * signs[i + signShiftX], y + halfSideSize * signs[i + signShiftY], z + halfSideSize * signs[i + signShiftZ]);
            if (enColor) {
                vertices.m_85950_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            vertices.m_5752_();
        }
    }
}

