/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.block;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.BusInterfaceScreen;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.BusCableBlockEntity;
import li.cil.oc2.common.integration.Wrenches;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class BusCableBlock
extends BaseEntityBlock {
    public static final BooleanProperty HAS_CABLE = BooleanProperty.m_61465_((String)"has_cable");
    public static final BooleanProperty HAS_FACADE = BooleanProperty.m_61465_((String)"has_facade");
    public static final EnumProperty<ConnectionType> CONNECTION_NORTH = EnumProperty.m_61587_((String)"connection_north", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_EAST = EnumProperty.m_61587_((String)"connection_east", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_SOUTH = EnumProperty.m_61587_((String)"connection_south", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_WEST = EnumProperty.m_61587_((String)"connection_west", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_UP = EnumProperty.m_61587_((String)"connection_up", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_DOWN = EnumProperty.m_61587_((String)"connection_down", ConnectionType.class);
    public static final Map<Direction, EnumProperty<ConnectionType>> FACING_TO_CONNECTION_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, CONNECTION_NORTH);
        directions.put(Direction.EAST, CONNECTION_EAST);
        directions.put(Direction.SOUTH, CONNECTION_SOUTH);
        directions.put(Direction.WEST, CONNECTION_WEST);
        directions.put(Direction.UP, CONNECTION_UP);
        directions.put(Direction.DOWN, CONNECTION_DOWN);
    });
    private final VoxelShape[] shapes;

    public static ConnectionType getConnectionType(BlockState state, @Nullable Direction direction) {
        if (direction != null) {
            return (ConnectionType)((Object)state.m_61143_((Property)FACING_TO_CONNECTION_MAP.get(direction)));
        }
        return ConnectionType.NONE;
    }

    public static int getInterfaceCount(BlockState state) {
        int partCount = 0;
        for (EnumProperty<ConnectionType> connectionType : FACING_TO_CONNECTION_MAP.values()) {
            if (state.m_61143_(connectionType) != ConnectionType.INTERFACE) continue;
            ++partCount;
        }
        return partCount;
    }

    public static Direction getHitSide(BlockPos pos, BlockHitResult hit) {
        Vec3 localHitPos = hit.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)pos));
        return Direction.m_122366_((double)localHitPos.f_82479_, (double)localHitPos.f_82480_, (double)localHitPos.f_82481_);
    }

    public BusCableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(1.5f, 6.0f));
        BlockState defaultState = (BlockState)this.m_49965_().m_61090_();
        for (EnumProperty<ConnectionType> property : FACING_TO_CONNECTION_MAP.values()) {
            defaultState = (BlockState)defaultState.m_61124_(property, (Comparable)((Object)ConnectionType.NONE));
        }
        defaultState = (BlockState)defaultState.m_61124_((Property)HAS_CABLE, (Comparable)Boolean.valueOf(true));
        defaultState = (BlockState)defaultState.m_61124_((Property)HAS_FACADE, (Comparable)Boolean.valueOf(false));
        this.m_49959_(defaultState);
        this.shapes = BusCableBlock.makeShapes();
    }

    public static boolean addInterface(Level level, BlockPos pos, BlockState state, Direction side) {
        if (state.m_60734_() != Blocks.BUS_CABLE.get()) {
            return false;
        }
        if (((Boolean)state.m_61143_((Property)HAS_FACADE)).booleanValue()) {
            return false;
        }
        EnumProperty<ConnectionType> property = FACING_TO_CONNECTION_MAP.get(side);
        if (state.m_61143_(property) != ConnectionType.NONE) {
            return false;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_(property, (Comparable)((Object)ConnectionType.INTERFACE)), 11);
        BusCableBlock.onConnectionTypeChanged((LevelAccessor)level, pos, side, false);
        return true;
    }

    public static boolean addCable(Level level, BlockPos pos, BlockState state) {
        if (state.m_60734_() != Blocks.BUS_CABLE.get()) {
            return false;
        }
        if (((Boolean)state.m_61143_((Property)HAS_CABLE)).booleanValue()) {
            return false;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_CABLE, (Comparable)Boolean.valueOf(true)), 11);
        BusCableBlock.onConnectionTypeChanged((LevelAccessor)level, pos, null, false);
        return true;
    }

    public static void setHasFacade(Level level, BlockPos pos, BlockState state, @Nullable BlockState facadeState, boolean value) {
        if ((Boolean)state.m_61143_((Property)HAS_FACADE) == value) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_FACADE, (Comparable)Boolean.valueOf(value)), 11);
        BlockState soundsSource = facadeState != null ? facadeState : state;
        LevelUtils.playSound((LevelAccessor)level, pos, soundsSource.m_60827_(), value ? SoundType::m_56777_ : SoundType::m_56775_);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block changedBlock, BlockPos changedBlockPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BusCableBlockEntity) {
            BusCableBlockEntity busCable = (BusCableBlockEntity)blockEntity;
            busCable.handleNeighborChanged(changedBlockPos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == Items.BUS_CABLE.get() || heldItem.m_41720_() == Items.BUS_INTERFACE.get()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BusCableBlockEntity)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        BusCableBlockEntity busCableBlockEntity = (BusCableBlockEntity)blockEntity;
        if (Wrenches.isWrench(heldItem)) {
            Direction side;
            if (player.m_6144_()) {
                ItemStack facadeItem = busCableBlockEntity.getFacade();
                if (!facadeItem.m_41619_()) {
                    if (!level.m_5776_()) {
                        busCableBlockEntity.removeFacade();
                        if (!player.m_7500_() && level.m_46469_().m_46207_(GameRules.f_46136_)) {
                            ItemStackUtils.spawnAsEntity(level, pos, facadeItem, hit.m_82434_()).ifPresent(entity -> {
                                entity.m_32061_();
                                entity.m_6123_(player);
                            });
                        }
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                if (BusCableBlock.getPartCount(state) > 1 && (BusCableBlock.tryRemoveInterface(state, level, pos, player, hit) || BusCableBlock.tryRemoveCable(state, level, pos, player))) {
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            } else if (level.m_5776_() && BusCableBlock.getConnectionType(state, side = BusCableBlock.getHitSide(pos, hit)) == ConnectionType.INTERFACE) {
                BusCableBlock.openBusInterfaceScreen(busCableBlockEntity, side);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (!player.m_6144_() && !((Boolean)state.m_61143_((Property)HAS_FACADE)).booleanValue() && BusCableBlock.getInterfaceCount(state) == 0) {
            switch (busCableBlockEntity.getFacadeType(heldItem)) {
                case INVALID_BLOCK: {
                    if (!level.m_5776_()) {
                        player.m_5661_((Component)TranslationUtils.text("message.{mod}.invalid_facade_block"), true);
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                case VALID_BLOCK: {
                    if (!level.m_5776_()) {
                        busCableBlockEntity.setFacade(heldItem);
                        if (!player.m_150110_().f_35937_) {
                            heldItem.m_41774_(1);
                        }
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BusCableBlockEntity busCable;
        ItemStack stack;
        BlockEntity blockEntity;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_49635_(state, builder));
        if (((Boolean)state.m_61143_((Property)HAS_FACADE)).booleanValue() && (blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_)) instanceof BusCableBlockEntity && !(stack = (busCable = (BusCableBlockEntity)blockEntity).getFacade()).m_41619_()) {
            drops.add(stack);
        }
        if (((Boolean)state.m_61143_((Property)HAS_CABLE)).booleanValue()) {
            drops.add(new ItemStack((ItemLike)Items.BUS_CABLE.get()));
        }
        int interfaceCount = 0;
        for (Direction side : Constants.DIRECTIONS) {
            ConnectionType connectionType = (ConnectionType)((Object)state.m_61143_((Property)FACING_TO_CONNECTION_MAP.get(side)));
            if (connectionType != ConnectionType.INTERFACE) continue;
            ++interfaceCount;
        }
        if (interfaceCount > 0) {
            drops.add(new ItemStack((ItemLike)Items.BUS_INTERFACE.get(), interfaceCount));
        }
        return drops;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Level level = context.m_43725_();
        BlockPos position = context.m_8083_();
        for (Map.Entry<Direction, EnumProperty<ConnectionType>> entry : FACING_TO_CONNECTION_MAP.entrySet()) {
            Direction facing = entry.getKey();
            BlockPos facingPos = position.m_121945_(facing);
            if (context.m_43722_().m_41720_() != Items.BUS_CABLE.get() || !BusCableBlock.canHaveCableTo(level.m_8055_(facingPos), facing.m_122424_())) continue;
            state = (BlockState)state.m_61124_((Property)entry.getValue(), (Comparable)((Object)ConnectionType.CABLE));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        boolean neighborConnectionChanged;
        EnumProperty<ConnectionType> property = FACING_TO_CONNECTION_MAP.get(facing);
        if (state.m_61143_(property) == ConnectionType.INTERFACE) {
            return state;
        }
        if (((Boolean)state.m_61143_((Property)HAS_CABLE)).booleanValue() && BusCableBlock.canHaveCableTo(facingState, facing.m_122424_())) {
            neighborConnectionChanged = state.m_61143_(property) != ConnectionType.CABLE;
            state = (BlockState)state.m_61124_(property, (Comparable)((Object)ConnectionType.CABLE));
        } else {
            neighborConnectionChanged = state.m_61143_(property) != ConnectionType.NONE;
            state = (BlockState)state.m_61124_(property, (Comparable)((Object)ConnectionType.NONE));
        }
        BusCableBlock.onConnectionTypeChanged(level, currentPos, facing, neighborConnectionChanged);
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)HAS_FACADE)).booleanValue()) {
            return Shapes.m_83144_();
        }
        return this.shapes[BusCableBlock.getShapeIndex(state)];
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult hit, BlockGetter level, BlockPos pos, Player player) {
        BlockHitResult blockHit;
        Direction side;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BusCableBlockEntity)) {
            return super.getCloneItemStack(state, hit, level, pos, player);
        }
        BusCableBlockEntity busCable = (BusCableBlockEntity)blockEntity;
        ItemStack facadeItem = busCable.getFacade();
        if (!facadeItem.m_41619_()) {
            return facadeItem;
        }
        if (hit instanceof BlockHitResult && BusCableBlock.getConnectionType(state, side = BusCableBlock.getHitSide(pos, blockHit = (BlockHitResult)hit)) == ConnectionType.INTERFACE) {
            return new ItemStack((ItemLike)Items.BUS_INTERFACE.get());
        }
        return super.getCloneItemStack(state, hit, level, pos, player);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntities.BUS_CABLE.get()).m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        FACING_TO_CONNECTION_MAP.values().forEach(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
        builder.m_61104_(new Property[]{HAS_CABLE});
        builder.m_61104_(new Property[]{HAS_FACADE});
    }

    private static boolean canHaveCableTo(BlockState state, Direction side) {
        return state.m_60734_() == Blocks.BUS_CABLE.get() && (Boolean)state.m_61143_((Property)HAS_CABLE) != false && state.m_61143_((Property)FACING_TO_CONNECTION_MAP.get(side)) != ConnectionType.INTERFACE;
    }

    private static int getPartCount(BlockState state) {
        int partCount = BusCableBlock.getInterfaceCount(state);
        if (((Boolean)state.m_61143_((Property)HAS_CABLE)).booleanValue()) {
            ++partCount;
        }
        return partCount;
    }

    private static boolean tryRemoveInterface(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean isReplacedByCable;
        Direction side = BusCableBlock.getHitSide(pos, hit);
        EnumProperty<ConnectionType> property = FACING_TO_CONNECTION_MAP.get(side);
        if (state.m_61143_(property) != ConnectionType.INTERFACE) {
            return false;
        }
        BlockPos neighborPos = pos.m_121945_(side);
        boolean bl = isReplacedByCable = (Boolean)state.m_61143_((Property)HAS_CABLE) != false && BusCableBlock.canHaveCableTo(level.m_8055_(neighborPos), side.m_122424_());
        if (isReplacedByCable) {
            level.m_46597_(pos, (BlockState)state.m_61124_(property, (Comparable)((Object)ConnectionType.CABLE)));
        } else {
            level.m_46597_(pos, (BlockState)state.m_61124_(property, (Comparable)((Object)ConnectionType.NONE)));
        }
        BusCableBlock.handlePartRemoved(state, level, pos, side, player, new ItemStack((ItemLike)Items.BUS_INTERFACE.get()), isReplacedByCable);
        return true;
    }

    private static boolean tryRemoveCable(BlockState state, Level level, BlockPos pos, Player player) {
        if (!((Boolean)state.m_61143_((Property)HAS_CABLE)).booleanValue()) {
            return false;
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_CABLE, (Comparable)Boolean.valueOf(false)));
        BusCableBlock.handlePartRemoved(state, level, pos, null, player, new ItemStack((ItemLike)Items.BUS_CABLE.get()), true);
        return true;
    }

    private static void handlePartRemoved(BlockState state, Level level, BlockPos pos, @Nullable Direction side, Player player, ItemStack drop, boolean neighborConnectionChanged) {
        BusCableBlock.onConnectionTypeChanged((LevelAccessor)level, pos, side, neighborConnectionChanged);
        if (!player.m_7500_() && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            ItemStackUtils.spawnAsEntity(level, pos, drop, side).ifPresent(entity -> {
                entity.m_32061_();
                entity.m_6123_(player);
            });
        }
        LevelUtils.playSound((LevelAccessor)level, pos, state.m_60827_(), SoundType::m_56775_);
    }

    private static void onConnectionTypeChanged(LevelAccessor level, BlockPos pos, @Nullable Direction face, boolean neighborConnectionChanged) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BusCableBlockEntity) {
            BusCableBlockEntity busCable = (BusCableBlockEntity)blockEntity;
            busCable.handleConfigurationChanged(face, neighborConnectionChanged);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openBusInterfaceScreen(BusCableBlockEntity blockEntity, Direction side) {
        BusInterfaceScreen screen = new BusInterfaceScreen(blockEntity, side);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private static VoxelShape[] makeShapes() {
        VoxelShape ownCableBounds = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
        VoxelShape[] cableShapes = new VoxelShape[Constants.BLOCK_FACE_COUNT];
        VoxelShape[] interfaceShapes = new VoxelShape[Constants.BLOCK_FACE_COUNT];
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            cableShapes[i] = BusCableBlock.getCableShape(Constants.DIRECTIONS[i]);
            interfaceShapes[i] = BusCableBlock.getInterfaceShape(Constants.DIRECTIONS[i]);
        }
        int configurations = 8192;
        Object[] result = new VoxelShape[8192];
        Arrays.fill(result, Shapes.m_83040_());
        for (int i = 0; i < result.length; ++i) {
            int mask = i >> 1;
            for (int sideIndex = 0; sideIndex < Constants.BLOCK_FACE_COUNT; ++sideIndex) {
                int interfaceBit;
                int cableBit = 1 << sideIndex;
                if ((mask & cableBit) != 0) {
                    result[i] = Shapes.m_83110_((VoxelShape)result[i], (VoxelShape)cableShapes[sideIndex]);
                }
                if ((mask & (interfaceBit = cableBit << 6)) == 0) continue;
                result[i] = Shapes.m_83110_((VoxelShape)result[i], (VoxelShape)interfaceShapes[sideIndex]);
            }
            if ((i & 1) == 0) continue;
            result[i] = Shapes.m_83110_((VoxelShape)result[i], (VoxelShape)ownCableBounds);
        }
        return result;
    }

    private static VoxelShape getCableShape(Direction zDirection) {
        int xSize = 6;
        int ySize = 6;
        int zSize = 5;
        Direction yDirection = zDirection.m_122434_() == Direction.Axis.Y ? Direction.NORTH : Direction.UP;
        Direction xDirection = zDirection.m_122434_() == Direction.Axis.Y ? Direction.WEST : zDirection.m_122427_();
        Vec3i min = new Vec3i(8, 8, 8).m_5484_(xDirection, -3).m_5484_(yDirection, -3).m_5484_(zDirection, 3);
        Vec3i max = new Vec3i(8, 8, 8).m_5484_(xDirection, 3).m_5484_(yDirection, 3).m_5484_(zDirection, 8);
        AABB bounds = new AABB(Vec3.m_82528_((Vec3i)min).m_82490_(0.0625), Vec3.m_82528_((Vec3i)max).m_82490_(0.0625));
        return Shapes.m_83064_((AABB)bounds);
    }

    private static VoxelShape getInterfaceShape(Direction zDirection) {
        int xSize = 8;
        int ySize = 8;
        boolean zSize = true;
        Direction yDirection = zDirection.m_122434_() == Direction.Axis.Y ? Direction.NORTH : Direction.UP;
        Direction xDirection = zDirection.m_122434_() == Direction.Axis.Y ? Direction.WEST : zDirection.m_122427_();
        Vec3i min = new Vec3i(8, 8, 8).m_5484_(xDirection, -4).m_5484_(yDirection, -4).m_5484_(zDirection, 7);
        Vec3i max = new Vec3i(8, 8, 8).m_5484_(xDirection, 4).m_5484_(yDirection, 4).m_5484_(zDirection, 8);
        AABB bounds = new AABB(Vec3.m_82528_((Vec3i)min).m_82490_(0.0625), Vec3.m_82528_((Vec3i)max).m_82490_(0.0625));
        return Shapes.m_83110_((VoxelShape)BusCableBlock.getCableShape(zDirection), (VoxelShape)Shapes.m_83064_((AABB)bounds));
    }

    private static int getShapeIndex(BlockState state) {
        int index = 0;
        block4: for (int sideIndex = 0; sideIndex < Constants.BLOCK_FACE_COUNT; ++sideIndex) {
            int cableBit = 1 << sideIndex;
            int interfaceBit = cableBit << 6;
            switch ((ConnectionType)((Object)state.m_61143_((Property)FACING_TO_CONNECTION_MAP.get(Constants.DIRECTIONS[sideIndex])))) {
                case CABLE: {
                    index |= cableBit;
                    continue block4;
                }
                case INTERFACE: {
                    index |= interfaceBit;
                }
            }
        }
        index <<= 1;
        if (((Boolean)state.m_61143_((Property)HAS_CABLE)).booleanValue()) {
            index |= 1;
        }
        return index;
    }

    public static enum ConnectionType implements StringRepresentable
    {
        NONE,
        CABLE,
        INTERFACE;


        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> "none";
                case CABLE -> "cable";
                case INTERFACE -> "interface";
            };
        }
    }
}

