/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.DeviceBus;
import li.cil.oc2.client.model.BusCableBakedModel;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.block.BusCableBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.bus.AbstractBlockDeviceBusElement;
import li.cil.oc2.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.BusCableFacadeMessage;
import li.cil.oc2.common.network.message.BusInterfaceNameMessage;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.util.ServerScheduler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.LazyOptional;

public final class BusCableBlockEntity
extends ModBlockEntity {
    private ModelData currentModelData = ModelData.EMPTY;
    private static final String BUS_ELEMENT_TAG_NAME = "busElement";
    private static final String INTERFACE_NAMES_TAG_NAME = "interfaceNames";
    private static final String FACADE_TAG_NAME = "facade";
    private final AbstractBlockDeviceBusElement busElement = new BusCableBusElement();
    private final String[] interfaceNames = new String[Constants.BLOCK_FACE_COUNT];
    private final NeighborTracker[] neighborTrackers = new NeighborTracker[Constants.BLOCK_FACE_COUNT];
    private ItemStack facade = ItemStack.f_41583_;

    public BusCableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.BUS_CABLE.get(), pos, state);
        for (Direction side : Direction.values()) {
            this.neighborTrackers[side.m_122411_()] = new NeighborTracker(side);
        }
        this.requestModelDataUpdate();
    }

    public String getInterfaceName(Direction side) {
        String interfaceName = this.interfaceNames[side.m_122411_()];
        return interfaceName == null ? "" : interfaceName;
    }

    public void setInterfaceName(Direction side, String name) {
        if (this.f_58857_ == null) {
            return;
        }
        String validatedName = BusCableBlockEntity.validateName(name);
        if (Objects.equals(validatedName, this.interfaceNames[side.m_122411_()])) {
            return;
        }
        this.interfaceNames[side.m_122411_()] = validatedName;
        this.m_6596_();
        if (!this.f_58857_.m_5776_()) {
            BusInterfaceNameMessage.ToClient message = new BusInterfaceNameMessage.ToClient(this, side, this.interfaceNames[side.m_122411_()]);
            Network.sendToClientsTrackingBlockEntity(message, this);
            this.busElement.updateDevicesForNeighbor(side);
        }
    }

    public FacadeType getFacadeType(ItemStack stack) {
        return this.getFacadeType(ItemStackUtils.getBlockState(stack));
    }

    public FacadeType getFacadeType(@Nullable BlockState state) {
        if (state == null) {
            return FacadeType.NOT_A_BLOCK;
        }
        if (this.f_58857_ == null || state.m_60799_() != RenderShape.MODEL || !state.m_60804_((BlockGetter)this.f_58857_, this.m_58899_()) || state.m_60734_() instanceof EntityBlock) {
            return FacadeType.INVALID_BLOCK;
        }
        return FacadeType.VALID_BLOCK;
    }

    public ItemStack getFacade() {
        return this.facade;
    }

    public void setFacade(ItemStack stack) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState facadeState = ItemStackUtils.getBlockState(stack);
        if (this.getFacadeType(facadeState) != FacadeType.VALID_BLOCK) {
            stack = ItemStack.f_41583_;
        }
        if (ItemStack.m_41656_((ItemStack)stack, (ItemStack)this.facade)) {
            return;
        }
        this.facade = stack.m_41777_();
        this.facade.m_41764_(1);
        BusCableBlock.setHasFacade(this.f_58857_, this.m_58899_(), this.m_58900_(), facadeState, true);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        if (!this.f_58857_.m_5776_()) {
            BusCableFacadeMessage message = new BusCableFacadeMessage(this.m_58899_(), this.facade);
            Network.sendToClientsTrackingBlockEntity(message, this);
        }
        this.requestModelDataUpdate();
    }

    public void removeFacade() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState facadeState = ItemStackUtils.getBlockState(this.facade);
        this.facade = ItemStack.f_41583_;
        BusCableBlock.setHasFacade(this.f_58857_, this.m_58899_(), this.m_58900_(), facadeState, false);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        if (!this.f_58857_.m_5776_()) {
            BusCableFacadeMessage message = new BusCableFacadeMessage(this.m_58899_(), this.facade);
            Network.sendToClientsTrackingBlockEntity(message, this);
        }
        this.requestModelDataUpdate();
    }

    public void handleNeighborChanged(BlockPos pos) {
        BlockPos toPos = pos.m_121996_((Vec3i)this.m_58899_());
        Direction side = Direction.m_122378_((int)toPos.m_123341_(), (int)toPos.m_123342_(), (int)toPos.m_123343_());
        if (side != null) {
            this.busElement.updateDevicesForNeighbor(side);
        }
    }

    public void handleConfigurationChanged(@Nullable Direction side, boolean neighborConnectivityChanged) {
        if (side != null) {
            this.setInterfaceName(side, "");
            this.invalidateCapability(Capabilities.deviceBusElement(), side);
            NeighborTracker tracker = this.neighborTrackers[side.m_122411_()];
            tracker.updateListener();
            tracker.scheduleNeighborDeviceUpdate();
        }
        if (neighborConnectivityChanged) {
            this.busElement.scheduleScan();
        }
    }

    public ModelData getModelData() {
        if (this.f_58857_ == null) {
            return ModelData.EMPTY;
        }
        BlockState state = this.m_58900_();
        BlockPos pos = this.m_58899_();
        if (state.m_61138_((Property)BusCableBlock.HAS_FACADE) && ((Boolean)state.m_61143_((Property)BusCableBlock.HAS_FACADE)).booleanValue()) {
            ItemStack facadeItem = this.getFacade();
            BlockState facadeState = ItemStackUtils.getBlockState(facadeItem);
            if (facadeState == null) {
                facadeState = Blocks.f_50075_.m_49966_();
            }
            BlockModelShaper shapes = Minecraft.m_91087_().m_91289_().m_110907_();
            BakedModel model = shapes.m_110893_(facadeState);
            ModelData data = model.getModelData((BlockAndTintGetter)this.f_58857_, pos, facadeState, this.currentModelData);
            this.currentModelData = ModelData.builder().with(BusCableBakedModel.BUS_CABLE_FACADE_PROPERTY, (Object)new BusCableBakedModel.BusCableFacade(facadeState, model, data)).build();
            return this.currentModelData;
        }
        Direction supportSide = null;
        for (Direction direction : Constants.DIRECTIONS) {
            if (!BusCableBakedModel.isNeighborInDirectionSolid((BlockAndTintGetter)this.f_58857_, pos, direction)) continue;
            EnumProperty<BusCableBlock.ConnectionType> property = BusCableBlock.FACING_TO_CONNECTION_MAP.get(direction);
            if (state.m_61138_(property) && state.m_61143_(property) == BusCableBlock.ConnectionType.INTERFACE) {
                return this.currentModelData;
            }
            if (supportSide != null) continue;
            supportSide = direction;
        }
        if (supportSide != null) {
            this.currentModelData = ModelData.builder().with(BusCableBakedModel.BUS_CABLE_SUPPORT_PROPERTY, (Object)new BusCableBakedModel.BusCableSupportSide(supportSide)).build();
            return this.currentModelData;
        }
        return this.currentModelData;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_(INTERFACE_NAMES_TAG_NAME, (Tag)this.serializeInterfaceNames());
        tag.m_128365_(FACADE_TAG_NAME, (Tag)this.facade.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.deserializeInterfaceNames(tag.m_128437_(INTERFACE_NAMES_TAG_NAME, 8));
        this.setFacade(ItemStack.m_41712_((CompoundTag)tag.m_128469_(FACADE_TAG_NAME)));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(BUS_ELEMENT_TAG_NAME, (Tag)this.busElement.save());
        tag.m_128365_(INTERFACE_NAMES_TAG_NAME, (Tag)this.serializeInterfaceNames());
        tag.m_128365_(FACADE_TAG_NAME, (Tag)this.facade.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.busElement.load(tag.m_128469_(BUS_ELEMENT_TAG_NAME));
        this.deserializeInterfaceNames(tag.m_128437_(INTERFACE_NAMES_TAG_NAME, 8));
        this.facade = ItemStack.m_41712_((CompoundTag)tag.m_128469_(FACADE_TAG_NAME));
        this.requestModelDataUpdate();
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        if (BusCableBlock.getConnectionType(this.m_58900_(), direction) != BusCableBlock.ConnectionType.NONE) {
            collector.offer(Capabilities.deviceBusElement(), this.busElement);
        }
    }

    @Override
    protected void loadServer() {
        super.loadServer();
        for (NeighborTracker tracker : this.neighborTrackers) {
            tracker.updateListener();
            tracker.scheduleNeighborDeviceUpdate();
        }
        this.scheduleBusScanInAdjacentBusElements();
        this.requestModelDataUpdate();
    }

    @Override
    protected void unloadServer(boolean isRemove) {
        super.unloadServer(isRemove);
        if (isRemove) {
            this.busElement.setRemoved();
        }
        for (NeighborTracker tracker : this.neighborTrackers) {
            tracker.close();
        }
    }

    private ListTag serializeInterfaceNames() {
        ListTag tag = new ListTag();
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            tag.add((Object)StringTag.m_129297_((String)this.getInterfaceName(Direction.m_122376_((int)i))));
        }
        return tag;
    }

    private void deserializeInterfaceNames(ListTag tag) {
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            String name = tag.m_128778_(i).trim();
            this.interfaceNames[i] = name.substring(0, Math.min(32, name.length()));
        }
    }

    private static String validateName(String name) {
        String trimmed = name.trim();
        return trimmed.length() > 32 ? trimmed.substring(0, 32) : trimmed;
    }

    private void scheduleBusScanInAdjacentBusElements() {
        assert (this.f_58857_ != null);
        ServerScheduler.schedule((LevelAccessor)this.f_58857_, () -> {
            if (!this.isValid()) {
                return;
            }
            Level level = Objects.requireNonNull(this.m_58904_());
            BlockPos pos = this.m_58899_();
            for (Direction direction : Constants.DIRECTIONS) {
                BlockPos neighborPos = pos.m_121945_(direction);
                BlockEntity blockEntity = LevelUtils.getBlockEntityIfChunkExists((LevelAccessor)level, neighborPos);
                if (blockEntity == null) continue;
                LazyOptional capability = blockEntity.getCapability(Capabilities.deviceBusElement(), direction.m_122424_());
                capability.ifPresent(DeviceBus::scheduleScan);
            }
        });
    }

    private final class BusCableBusElement
    extends AbstractBlockDeviceBusElement {
        private BusCableBusElement() {
        }

        @Override
        @Nullable
        public LevelAccessor getLevel() {
            return BusCableBlockEntity.this.m_58904_();
        }

        @Override
        public BlockPos getPosition() {
            return BusCableBlockEntity.this.m_58899_();
        }

        @Override
        public boolean canScanContinueTowards(@Nullable Direction direction) {
            BusCableBlock.ConnectionType connectionType = BusCableBlock.getConnectionType(BusCableBlockEntity.this.m_58900_(), direction);
            return connectionType == BusCableBlock.ConnectionType.CABLE || connectionType == BusCableBlock.ConnectionType.INTERFACE;
        }

        @Override
        public boolean canDetectDevicesTowards(@Nullable Direction direction) {
            BusCableBlock.ConnectionType connectionType = BusCableBlock.getConnectionType(BusCableBlockEntity.this.m_58900_(), direction);
            return connectionType == BusCableBlock.ConnectionType.INTERFACE;
        }

        @Override
        protected void collectSyntheticDevices(LevelAccessor level, BlockPos pos, @Nullable Direction side, HashSet<AbstractBlockDeviceBusElement.BlockEntry> entries) {
            super.collectSyntheticDevices(level, pos, side, entries);
            if (side == null || entries.isEmpty()) {
                return;
            }
            String interfaceName = BusCableBlockEntity.this.interfaceNames[side.m_122411_()];
            if (!StringUtil.m_14408_((String)interfaceName)) {
                entries.add(new AbstractBlockDeviceBusElement.BlockEntry((AbstractBlockDeviceBusElement)this, new BlockDeviceInfo(null, new TypeNameRPCDevice(interfaceName)), side));
            }
        }

        @Override
        public double getEnergyConsumption() {
            return super.getEnergyConsumption() + Config.busCableEnergyPerTick + (double)BusCableBlock.getInterfaceCount(BusCableBlockEntity.this.m_58900_()) * Config.busInterfaceEnergyPerTick;
        }
    }

    private final class NeighborTracker
    implements AutoCloseable {
        private final Runnable onChunkLoadedStateChanged = this::handleChunkLoadOrUnload;
        final Direction side;
        final EnumProperty<BusCableBlock.ConnectionType> connectionProperty;
        private final ChunkPos chunkPos;
        private final boolean isSameChunk;
        private boolean hasRegisteredListener;
        private boolean hasScheduledUpdate;

        public NeighborTracker(Direction side) {
            this.side = side;
            this.connectionProperty = BusCableBlock.FACING_TO_CONNECTION_MAP.get(side);
            this.chunkPos = new ChunkPos(BusCableBlockEntity.this.m_58899_().m_121945_(side));
            this.isSameChunk = Objects.equals(new ChunkPos(BusCableBlockEntity.this.m_58899_()), this.chunkPos);
        }

        @Override
        public void close() {
            this.removeListener();
        }

        public void scheduleNeighborDeviceUpdate() {
            if (BusCableBlockEntity.this.f_58857_ != null && !this.hasScheduledUpdate) {
                ServerScheduler.schedule((LevelAccessor)BusCableBlockEntity.this.f_58857_, this::updateNeighborDevices);
                this.hasScheduledUpdate = true;
            }
        }

        public void updateListener() {
            boolean needsListener;
            if (this.isSameChunk) {
                return;
            }
            boolean bl = needsListener = BusCableBlockEntity.this.m_58900_().m_61143_(this.connectionProperty) == BusCableBlock.ConnectionType.INTERFACE;
            if (needsListener && !this.hasRegisteredListener) {
                this.addListener();
            } else if (!needsListener && this.hasRegisteredListener) {
                this.removeListener();
            }
        }

        private void addListener() {
            if (BusCableBlockEntity.this.f_58857_ != null && !this.hasRegisteredListener) {
                ServerScheduler.subscribeOnLoad((LevelAccessor)BusCableBlockEntity.this.f_58857_, this.chunkPos, this.onChunkLoadedStateChanged);
                ServerScheduler.subscribeOnUnload((LevelAccessor)BusCableBlockEntity.this.f_58857_, this.chunkPos, this.onChunkLoadedStateChanged);
            }
            this.hasRegisteredListener = true;
        }

        private void removeListener() {
            if (BusCableBlockEntity.this.f_58857_ != null && this.hasRegisteredListener) {
                ServerScheduler.unsubscribeOnLoad((LevelAccessor)BusCableBlockEntity.this.f_58857_, this.chunkPos, this.onChunkLoadedStateChanged);
                ServerScheduler.unsubscribeOnUnload((LevelAccessor)BusCableBlockEntity.this.f_58857_, this.chunkPos, this.onChunkLoadedStateChanged);
            }
            this.hasRegisteredListener = false;
        }

        private void handleChunkLoadOrUnload() {
            this.scheduleNeighborDeviceUpdate();
        }

        private void updateNeighborDevices() {
            if (BusCableBlockEntity.this.isValid()) {
                BusCableBlockEntity.this.busElement.updateDevicesForNeighbor(this.side);
            }
            this.hasScheduledUpdate = false;
        }
    }

    public static enum FacadeType {
        NOT_A_BLOCK,
        INVALID_BLOCK,
        VALID_BLOCK;

    }
}

