/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.inet.InternetAdapter;
import li.cil.oc2.common.inet.InternetConnection;
import li.cil.oc2.common.inet.InternetManagerImpl;
import li.cil.oc2.common.util.ChunkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InternetGateWayBlockEntity
extends ModBlockEntity
implements NetworkInterface,
InternetAdapter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int QUEUE_MAX = 64;
    private final Deque<byte[]> inboundQueue;
    private final Deque<byte[]> outboundQueue;
    private InternetConnection internetConnection;
    private static final String STATE_TAG = "internet_adapter";
    private Tag internetState = null;
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.gatewayEnergyStorage);
    public static final int EMITTER_SIDE_PIXELS = 4;
    public float[] animProgress;
    public boolean[] animReversed;
    public int inboundCount = 0;
    public int outboundCount = 0;
    public int handledInboundCount = 0;
    public int handledOutboundCount = 0;
    public long lastRender = 0L;
    public int pointer = 0;

    protected InternetGateWayBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.INTERNET_GATEWAY.get(), pos, state);
        this.inboundQueue = new ArrayDeque<byte[]>();
        this.outboundQueue = new ArrayDeque<byte[]>();
        this.animProgress = new float[16];
        this.animReversed = new boolean[16];
        this.setNeedsLevelUnloadEvent();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.internetState = tag.m_128423_("InternetAdapter");
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.internetConnection != null) {
            this.internetConnection.saveAdapterState().ifPresent(adapterState -> tag.m_128365_("InternetAdapter", adapterState));
        }
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        LOGGER.trace("State saved");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("inbound_count", this.inboundCount);
        tag.m_128405_("outbound_count", this.outboundCount);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundtag = pkt.m_131708_();
        if (compoundtag != null) {
            this.handleUpdateTag(compoundtag);
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.inboundCount = tag.m_128451_("inbound_count");
        this.outboundCount = tag.m_128451_("outbound_count");
        this.handledInboundCount = Math.max(this.handledInboundCount, this.inboundCount - 128);
        this.handledOutboundCount = Math.max(this.handledOutboundCount, this.outboundCount - 128);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    protected void loadServer() {
        InternetManagerImpl.getInstance().ifPresent(internetManager -> {
            this.internetConnection = internetManager.connect(this, this.internetState);
        });
        if (this.internetConnection != null) {
            LOGGER.trace("Connected to the internet");
        } else {
            LOGGER.trace("Not connected to the internet");
        }
    }

    @Override
    protected void unloadServer(boolean isRemove) {
        if (this.internetConnection != null) {
            this.internetConnection.stop();
            LOGGER.trace("Connection stopped");
        }
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.networkInterface(), this);
        collector.offer(Capabilities.energyStorage(), this.energy);
    }

    @Override
    public byte[] receiveEthernetFrame() {
        return this.outboundQueue.pollFirst();
    }

    private boolean tryUseEnergy() {
        boolean hasEnough;
        boolean bl = hasEnough = this.energy.getEnergyStored() >= Config.gatewayEnergyPerPacket;
        if (hasEnough) {
            this.energy.extractEnergy(Config.gatewayEnergyPerPacket, false);
            Level level = this.m_58904_();
            if (level != null) {
                ChunkUtils.setLazyUnsaved((LevelAccessor)level, this.m_58899_());
            }
        }
        return hasEnough;
    }

    private void notifyPlayers() {
        Level level = this.m_58904_();
        if (level != null) {
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Override
    public void sendEthernetFrame(byte[] frame) {
        LOGGER.trace("Got inbound packet");
        if (this.inboundQueue.size() < 64 && this.tryUseEnergy()) {
            ++this.inboundCount;
            this.notifyPlayers();
            this.inboundQueue.addLast(frame);
        }
    }

    @Override
    public byte[] readEthernetFrame() {
        return this.inboundQueue.pollFirst();
    }

    @Override
    public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
        LOGGER.trace("Got outbound packet");
        if (this.outboundQueue.size() < 64 && this.tryUseEnergy()) {
            ++this.outboundCount;
            this.notifyPlayers();
            this.outboundQueue.addLast(frame);
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_7918_(1, 2, 1));
    }
}

