/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider.item;

import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.data.BlockDeviceData;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.bus.device.provider.util.AbstractItemDeviceProvider;
import li.cil.oc2.common.bus.device.vm.item.HardDriveDeviceWithInitialData;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.item.HardDriveWithExternalDataItem;
import li.cil.oc2.common.util.LocationSupplierUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public final class HardDriveWithExternalDataItemDeviceProvider
extends AbstractItemDeviceProvider {
    public HardDriveWithExternalDataItemDeviceProvider() {
        super(HardDriveWithExternalDataItem.class);
    }

    @Override
    public void unmount(@Nullable ItemDeviceQuery query, CompoundTag tag) {
        super.unmount(query, tag);
        HardDriveDeviceWithInitialData.unmount(tag);
    }

    @Override
    protected Optional<ItemDevice> getItemDevice(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        HardDriveWithExternalDataItem item = (HardDriveWithExternalDataItem)stack.m_41720_();
        BlockDeviceData data = item.getData(stack);
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(new HardDriveDeviceWithInitialData(stack, data.getBlockDevice(), false, LocationSupplierUtils.of(query)));
    }

    @Override
    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        HardDriveWithExternalDataItem item = (HardDriveWithExternalDataItem)stack.m_41720_();
        BlockDeviceData data = item.getData(stack);
        if (data == null) {
            return 0;
        }
        long capacity = Math.max(data.getBlockDevice().getCapacity(), 0L);
        return Math.max(1, (int)Math.round((double)capacity * Config.hardDriveEnergyPerMegabytePerTick / 1048576.0));
    }
}

