/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.config.common;

import li.cil.oc2.common.config.Config;
import net.minecraftforge.common.ForgeConfigSpec;

public class VMSpec {
    public final ForgeConfigSpec.LongValue maxAllocatedMemory;
    public final ForgeConfigSpec.IntValue diskSizeFactor;

    VMSpec(ForgeConfigSpec.Builder builder) {
        this.maxAllocatedMemory = builder.comment("Maximum memory that can be allocated across all virtual machines (computers/robots) at any one time (in bytes)").defineInRange("maxAllocatedMemory", 0x20000000L, 0L, Long.MAX_VALUE);
        this.diskSizeFactor = builder.comment(new String[]{"Determines the size factor of drives, where SF is the size factor set below the sizes are as follows (this settings is in bytes):", "Small Disk: SF", "Medium Disk: 2 * SF", "Large Disk: 4 * SF", "Extra Large Disk: 16 * SF", "With the default factor this is equivalent to (in the same order) 2MB, 4MB, 8MB, 32MB."}).defineInRange("diskSizeFactor", 0x200000, 0, Integer.MAX_VALUE);
    }

    public void loadValues() {
        Config.maxAllocatedMemory = (Long)this.maxAllocatedMemory.get();
        Config.diskSizeFactor = (Integer)this.diskSizeFactor.get();
    }
}

