/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import javax.annotation.Nonnull;
import li.cil.oc2.common.bus.AbstractItemDeviceBusElement;
import li.cil.oc2.common.container.FixedSizeItemStackHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractDeviceItemStackHandler
extends FixedSizeItemStackHandler {
    public AbstractDeviceItemStackHandler(int size) {
        this((NonNullList<ItemStack>)NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_));
    }

    public AbstractDeviceItemStackHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public abstract AbstractItemDeviceBusElement getBusElement();

    public void exportDeviceDataToItemStacks() {
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.getBusElement().exportDeviceDataToItemStack(slot, this.getStackInSlot(slot));
        }
    }

    public final CompoundTag serializeNBT() {
        throw new UnsupportedOperationException("Use saveItems and saveDevices instead.");
    }

    @Override
    public final void deserializeNBT(CompoundTag tag) {
        throw new UnsupportedOperationException("Use loadItems and loadDevices instead.");
    }

    public CompoundTag saveItems() {
        return super.serializeNBT();
    }

    public CompoundTag saveDevices() {
        return this.getBusElement().save();
    }

    public void loadItems(CompoundTag tag) {
        super.deserializeNBT(tag);
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.getBusElement().handleSlotContentsChanged(slot, this.getStackInSlot(slot));
        }
    }

    public void loadDevices(CompoundTag tag) {
        this.getBusElement().load(tag);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemStack stack = super.getStackInSlot(slot);
        this.getBusElement().exportDeviceDataToItemStack(slot, stack);
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate && amount > 0) {
            this.getBusElement().exportDeviceDataToItemStack(slot, super.getStackInSlot(slot));
        }
        return super.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.getBusElement().handleSlotContentsChanged(slot, this.getStackInSlot(slot));
    }
}

