/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractRobotContainer;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.container.IntPrecisionContainerData;
import li.cil.oc2.common.container.RobotSlot;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.entity.Robot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public final class RobotTerminalContainer
extends AbstractRobotContainer {
    public static void createServer(final Robot robot, final FixedEnergyStorage energy, final CommonDeviceBusController busController, ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return robot.m_7755_();
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                return new RobotTerminalContainer(id, player, robot, AbstractRobotContainer.createEnergyInfo(energy, busController));
            }
        }, b -> b.m_130130_(robot.m_19879_()));
    }

    public static RobotTerminalContainer createClient(int id, Inventory inventory, FriendlyByteBuf data) {
        int entityId = data.m_130242_();
        Entity entity = inventory.f_35978_.m_9236_().m_6815_(entityId);
        if (entity instanceof Robot) {
            Robot robot = (Robot)entity;
            return new RobotTerminalContainer(id, inventory.f_35978_, robot, RobotTerminalContainer.createClientEnergyInfo());
        }
        throw new IllegalArgumentException();
    }

    private RobotTerminalContainer(int id, Player player, Robot robot, IntPrecisionContainerData energyInfo) {
        super((MenuType)Containers.ROBOT_TERMINAL.get(), id, player, robot, energyInfo);
        int terminalScreenWidth = Sprites.TERMINAL_SCREEN.width;
        int terminalScreenHeight = Sprites.TERMINAL_SCREEN.height;
        ItemStackHandler inventory = robot.getInventory();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            int x = (terminalScreenWidth - inventory.getSlots() * 18) / 2 + 1 + slot * 18;
            this.m_38897_((Slot)new RobotSlot((IItemHandler)inventory, slot, x, terminalScreenHeight + 4));
        }
    }
}

