/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.event;

import javax.annotation.Nullable;
import li.cil.oc2.common.util.AsyncUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="oc2r", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventHandlers {
    private static final Logger LOGGER = LogManager.getLogger();
    private static MinecraftServer server;

    @Nullable
    public static MinecraftServer getCurrentServer() {
        return server;
    }

    @SubscribeEvent
    public static void handleServerAboutToStart(ServerAboutToStartEvent event) {
        server = event.getServer();
        LOGGER.info("Server starting, initializing async components");
    }

    @SubscribeEvent
    public static void handleServerStopped(ServerStoppedEvent event) {
        LOGGER.info("Server stopped, cleaning up async components");
        try {
            AsyncUtils.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("Error during async component shutdown", (Throwable)e);
        }
        finally {
            server = null;
        }
    }
}

