/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.util.Objects;
import li.cil.oc2.common.inet.EchoSessionImpl;
import li.cil.oc2.common.inet.InetUtils;
import li.cil.oc2.common.inet.SessionDiscriminator;

final class EchoSessionDiscriminator
implements SessionDiscriminator<EchoSessionImpl> {
    private final int srcIpAddress;
    private final int dstIpAddress;
    private final short identity;

    public EchoSessionDiscriminator(int srcIpAddress, int dstIpAddress, short identity) {
        this.srcIpAddress = srcIpAddress;
        this.dstIpAddress = dstIpAddress;
        this.identity = identity;
    }

    public int getSrcIpAddress() {
        return this.srcIpAddress;
    }

    public int getDstIpAddress() {
        return this.dstIpAddress;
    }

    public short getIdentity() {
        return this.identity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EchoSessionDiscriminator that = (EchoSessionDiscriminator)o;
        return this.srcIpAddress == that.srcIpAddress && this.dstIpAddress == that.dstIpAddress && this.identity == that.identity;
    }

    public int hashCode() {
        return Objects.hash(this.srcIpAddress, this.dstIpAddress, this.identity);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Echo(");
        InetUtils.ipv4AddressToString(builder, this.srcIpAddress);
        builder.append("<-[");
        builder.append(Short.toUnsignedInt(this.identity));
        builder.append("]->");
        InetUtils.ipv4AddressToString(builder, this.dstIpAddress);
        builder.append(')');
        return builder.toString();
    }
}

