/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.TextFormatUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class AbstractStorageItem
extends ModItem {
    private static final String CAPACITY_TAG_NAME = "capacity";
    private final int defaultCapacity;

    protected AbstractStorageItem(Item.Properties properties, int defaultCapacity) {
        super(properties);
        this.defaultCapacity = defaultCapacity;
    }

    protected AbstractStorageItem(int capacity) {
        this(AbstractStorageItem.createProperties(), capacity);
    }

    public int getCapacity(ItemStack stack) {
        CompoundTag tag = ItemStackUtils.getModDataTag(stack);
        if (!tag.m_128425_(CAPACITY_TAG_NAME, 3)) {
            return this.defaultCapacity;
        }
        return tag.m_128451_(CAPACITY_TAG_NAME);
    }

    public ItemStack withCapacity(ItemStack stack, int capacity) {
        ItemStackUtils.getOrCreateModDataTag(stack).m_128405_(CAPACITY_TAG_NAME, capacity);
        return stack;
    }

    public ItemStack withCapacity(int capacity) {
        return this.withCapacity(new ItemStack((ItemLike)this), capacity);
    }

    public Component m_7626_(ItemStack stack) {
        int capacity = this.getCapacity(stack);
        return Component.m_237113_((String)"").m_7220_(super.m_7626_(stack)).m_130946_(" (").m_130946_(TextFormatUtils.formatSize(capacity)).m_130946_(")");
    }
}

