/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import li.cil.oc2.common.blockentity.MonitorBlockEntity;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.MonitorFramebufferMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="oc2r", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class MonitorLoadBalancer {
    private static final long CACHE_EXPIRES_AFTER = 2000L;
    private static final Map<MonitorBlockEntity, ProjectorInfo> PROJECTOR_INFO = new HashMap<MonitorBlockEntity, ProjectorInfo>();
    private static final AtomicInteger BUDGET = new AtomicInteger(MonitorLoadBalancer.getMaxBudget());
    @Nullable
    private static ProjectorInfo lastSender;

    public static void updateWatcher(MonitorBlockEntity monitor, ServerPlayer player) {
        PROJECTOR_INFO.computeIfAbsent(monitor, MonitorLoadBalancer::addProjectorInfo).handleWatchedBy(player);
    }

    public static void offerFrame(MonitorBlockEntity monitor, Supplier<ByteBuffer> messageSupplier) {
        ProjectorInfo info = PROJECTOR_INFO.get(monitor);
        if (info != null) {
            info.nextFrameSupplier = messageSupplier;
        }
    }

    @SubscribeEvent
    public static void handleServerTick(TickEvent.ServerTickEvent event) {
        MonitorLoadBalancer.updateCache();
        if (BUDGET.updateAndGet(MonitorLoadBalancer::replenishBudget) > 0) {
            MonitorLoadBalancer.sendNextReadyPacket();
        }
    }

    @SubscribeEvent
    public static void handleServerStopped(ServerStoppedEvent event) {
        PROJECTOR_INFO.clear();
    }

    private static int getMaxBudget() {
        return Config.projectorAverageMaxBytesPerSecond / 2;
    }

    private static int replenishBudget(int budget) {
        return Math.min(MonitorLoadBalancer.getMaxBudget(), budget + Math.max(1, Config.projectorAverageMaxBytesPerSecond / 20));
    }

    private static void updateCache() {
        Iterator<ProjectorInfo> iterator = PROJECTOR_INFO.values().iterator();
        while (iterator.hasNext()) {
            ProjectorInfo info = iterator.next();
            info.removeExpiredPlayers();
            if (!info.isNoLongerWatched()) continue;
            iterator.remove();
            MonitorLoadBalancer.removeProjectorInfo(info);
        }
    }

    private static ProjectorInfo addProjectorInfo(MonitorBlockEntity monitor) {
        monitor.setRequiresKeyframe();
        ProjectorInfo info = new ProjectorInfo(monitor.m_58899_());
        if (lastSender == null) {
            lastSender = info;
        } else {
            lastSender.add(info);
        }
        return info;
    }

    private static void removeProjectorInfo(ProjectorInfo info) {
        if (lastSender == info) {
            lastSender = MonitorLoadBalancer.lastSender.next == lastSender ? null : info.next;
        }
        info.remove();
    }

    private static void sendNextReadyPacket() {
        if (lastSender == null) {
            return;
        }
        ProjectorInfo start = lastSender;
        do {
            if (!(lastSender = MonitorLoadBalancer.lastSender.next).sendIfReady()) continue;
            return;
        } while (lastSender != start);
    }

    private static class ProjectorInfo {
        private static final ExecutorService ENCODER_WORKERS = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Projector Frame Encoder");
            return thread;
        });
        private ProjectorInfo next;
        private ProjectorInfo previous;
        private final BlockPos projectorPos;
        private final WeakHashMap<ServerPlayer, Long> players = new WeakHashMap();
        private int skipCount;
        @Nullable
        private Supplier<ByteBuffer> nextFrameSupplier;
        @Nullable
        private Future<?> runningEncode;

        public ProjectorInfo(BlockPos projectorPos) {
            this.next = this.previous = this;
            this.projectorPos = projectorPos;
        }

        public void add(ProjectorInfo info) {
            info.next = this.next;
            this.next.previous = info;
            this.next = info;
            info.previous = this;
        }

        public void remove() {
            if (this.previous == null) {
                return;
            }
            this.previous.next = this.next;
            this.next.previous = this.previous;
            this.previous = null;
            this.next = null;
        }

        public void handleWatchedBy(ServerPlayer player) {
            this.players.put(player, System.currentTimeMillis());
        }

        public void removeExpiredPlayers() {
            this.players.entrySet().removeIf(entry -> System.currentTimeMillis() - (Long)entry.getValue() > 2000L);
        }

        public boolean isNoLongerWatched() {
            return this.players.isEmpty();
        }

        public boolean sendIfReady() {
            boolean isReady;
            if (this.skipCount > 0) {
                --this.skipCount;
                return false;
            }
            boolean bl = isReady = !this.players.isEmpty() && this.nextFrameSupplier != null && (this.runningEncode == null || this.runningEncode.isDone());
            if (isReady) {
                this.sendAsync();
                this.updateSkipCount();
            }
            return isReady;
        }

        private void sendAsync() {
            assert (this.nextFrameSupplier != null);
            Supplier<ByteBuffer> frameSupplier = this.nextFrameSupplier;
            this.nextFrameSupplier = null;
            assert (this.runningEncode == null || this.runningEncode.isDone());
            this.runningEncode = ENCODER_WORKERS.submit(() -> {
                ByteBuffer frame = (ByteBuffer)frameSupplier.get();
                if (frame == null) {
                    return;
                }
                int budgetCost = frame.limit() * this.players.size();
                BUDGET.accumulateAndGet(budgetCost, (budget, cost) -> budget - cost);
                MonitorFramebufferMessage message = new MonitorFramebufferMessage(this.projectorPos, frame);
                for (ServerPlayer player : this.players.keySet()) {
                    Network.sendToClient(message, player);
                }
            });
        }

        private void updateSkipCount() {
            this.skipCount = 0;
            double closestPlayerDistanceSqr = Double.MAX_VALUE;
            Vec3 blockCenter = Vec3.m_82512_((Vec3i)this.projectorPos);
            for (ServerPlayer player : this.players.keySet()) {
                ++this.skipCount;
                double distance = player.m_20238_(blockCenter);
                closestPlayerDistanceSqr = Math.min(closestPlayerDistanceSqr, distance);
            }
            double closestPlayerDistance = Math.sqrt(closestPlayerDistanceSqr);
            if (closestPlayerDistance > 16.0) {
                ++this.skipCount;
            }
        }
    }
}

