/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.AbstractMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MultipartMessage
extends AbstractMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_MULTIPART_MESSAGE_SIZE = 0x100000;
    private static final int MAX_PAYLOAD_SIZE = 8192;
    private static final int HEADER_SIZE = 11;
    private static final Cache<Integer, ByteBuf> MULTIPART_MESSAGE_BUFFER_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).build();
    private static int lastAssignedMultipartMessageId;
    private static final Map<Class<? extends AbstractMessage>, Entry> ENTRY_BY_TYPE;
    private static final Int2ObjectMap<Entry> ENTRY_BY_ID;
    private static int lastAssignedId;
    private boolean isFinalPart;
    private int messageId;
    private int multipartMessageId;
    private byte[] data;

    public static <T extends AbstractMessage> void registerMessage(Class<T> type, Function<FriendlyByteBuf, T> factory) {
        if (ENTRY_BY_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Message of this type has already been registered.");
        }
        int id = ++lastAssignedId;
        Entry entry = new Entry(id, factory);
        ENTRY_BY_TYPE.put(type, entry);
        ENTRY_BY_ID.put(id, (Object)entry);
    }

    public static void sendToServer(AbstractMessage message) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        message.toBytes(buffer);
        if (buffer.readableBytes() <= 8192) {
            Network.sendToServer(message);
            return;
        }
        if (buffer.readableBytes() > 0x100000) {
            throw new IllegalArgumentException("Message too large.");
        }
        Entry entry = ENTRY_BY_TYPE.get(message.getClass());
        if (entry == null) {
            throw new IllegalArgumentException("Trying to send multipart message of unregistered message (" + message.getClass().getName() + ").");
        }
        int messageId = entry.id();
        int multipartMessageId = ++lastAssignedMultipartMessageId;
        while (buffer.readableBytes() > 0) {
            int dataLength = Math.min(buffer.readableBytes(), 8181);
            byte[] data = new byte[dataLength];
            buffer.readBytes(data);
            Network.sendToServer(new MultipartMessage(messageId, multipartMessageId, data));
        }
    }

    public MultipartMessage(int messageId, int multipartMessageId, byte[] data) {
        this.messageId = messageId;
        this.multipartMessageId = multipartMessageId;
        this.data = data;
    }

    public MultipartMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.isFinalPart = buffer.readableBytes() < 8191;
        this.messageId = buffer.readInt();
        this.multipartMessageId = buffer.readInt();
        int length = buffer.readUnsignedShort();
        this.data = new byte[length];
        buffer.readBytes(this.data);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.messageId);
        buffer.writeInt(this.multipartMessageId);
        buffer.writeShort(this.data.length);
        buffer.writeBytes(this.data);
    }

    @Override
    protected void handleMessage(Supplier<NetworkEvent.Context> contextSupplier) {
        try {
            ByteBuf buffer = (ByteBuf)MULTIPART_MESSAGE_BUFFER_CACHE.get((Object)lastAssignedMultipartMessageId, Unpooled::buffer);
            if (buffer.capacity() == 0) {
                return;
            }
            buffer.writeBytes(this.data);
            if (buffer.readableBytes() > 0x100000) {
                LOGGER.error("Received over-sized multipart message from client [{}], ignoring.", (Object)contextSupplier.get().getSender());
                MULTIPART_MESSAGE_BUFFER_CACHE.put((Object)lastAssignedMultipartMessageId, (Object)Unpooled.buffer((int)0));
                return;
            }
            if (this.isFinalPart) {
                MULTIPART_MESSAGE_BUFFER_CACHE.invalidate((Object)lastAssignedMultipartMessageId);
                Entry entry = (Entry)ENTRY_BY_ID.get(this.messageId);
                if (entry == null) {
                    LOGGER.error("Received multipart message for unregistered message from client [{}]. Are the mod version on the server and client the same?", (Object)contextSupplier.get().getSender());
                    return;
                }
                entry.factory.apply(new FriendlyByteBuf(buffer)).handleMessage(contextSupplier);
            }
        }
        catch (ExecutionException e) {
            LOGGER.error("Error when handling multipart message received from client [{}]: {}", (Object)contextSupplier.get().getSender(), (Object)e);
        }
    }

    static {
        ENTRY_BY_TYPE = new HashMap<Class<? extends AbstractMessage>, Entry>();
        ENTRY_BY_ID = new Int2ObjectArrayMap();
    }

    private record Entry(int id, Function<FriendlyByteBuf, ? extends AbstractMessage> factory) {
    }
}

