/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;

public final class NBTToJsonConverter {
    public static JsonElement convert(@Nullable Tag tag) {
        if (tag == null) {
            return JsonNull.INSTANCE;
        }
        switch (tag.m_7060_()) {
            case 1: {
                return new JsonPrimitive((Number)((ByteTag)tag).m_7063_());
            }
            case 2: {
                return new JsonPrimitive((Number)((ShortTag)tag).m_7053_());
            }
            case 3: {
                return new JsonPrimitive((Number)((IntTag)tag).m_7047_());
            }
            case 4: {
                return new JsonPrimitive((Number)((LongTag)tag).m_7046_());
            }
            case 5: {
                return new JsonPrimitive((Number)Float.valueOf(((FloatTag)tag).m_7057_()));
            }
            case 6: {
                return new JsonPrimitive((Number)((DoubleTag)tag).m_7061_());
            }
            case 7: {
                byte[] array;
                JsonArray json = new JsonArray();
                for (byte b : array = ((ByteArrayTag)tag).m_128227_()) {
                    json.add((Number)b);
                }
                return json;
            }
            case 8: {
                return new JsonPrimitive(tag.m_7916_());
            }
            case 9: {
                JsonArray json = new JsonArray();
                ListTag listTag = (ListTag)tag;
                for (Tag item : listTag) {
                    json.add(NBTToJsonConverter.convert(item));
                }
                return json;
            }
            case 10: {
                JsonObject json = new JsonObject();
                CompoundTag compoundTag = (CompoundTag)tag;
                for (String key : compoundTag.m_128431_()) {
                    json.add(key, NBTToJsonConverter.convert(compoundTag.m_128423_(key)));
                }
                return json;
            }
            case 11: {
                int[] array;
                JsonArray json = new JsonArray();
                for (int j : array = ((IntArrayTag)tag).m_128648_()) {
                    json.add((Number)j);
                }
                return json;
            }
            case 12: {
                long[] array;
                JsonArray json = new JsonArray();
                for (long l : array = ((LongArrayTag)tag).m_128851_()) {
                    json.add((Number)l);
                }
                return json;
            }
        }
        return JsonNull.INSTANCE;
    }
}

