/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.OptionalLong;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.common.vm.BaseAddressProvider;
import li.cil.oc2.common.vm.context.global.GlobalVMContext;
import li.cil.oc2.common.vm.context.managed.ManagedVMContext;

public final class VMDeviceBusAdapter {
    private final HashMap<VMDevice, ManagedVMContext> mountedDevices = new HashMap();
    private final ArrayList<VMDevice> unmountedDevices = new ArrayList();
    private BaseAddressProvider baseAddressProvider = unused -> OptionalLong.empty();
    private final GlobalVMContext globalContext;

    public VMDeviceBusAdapter(GlobalVMContext context) {
        this.globalContext = context;
    }

    public void setBaseAddressProvider(BaseAddressProvider provider) {
        this.baseAddressProvider = provider;
    }

    public VMDeviceLoadResult mountDevices() {
        for (VMDevice device : this.unmountedDevices) {
            ManagedVMContext context = new ManagedVMContext(this.globalContext, this.globalContext, () -> this.baseAddressProvider.getBaseAddress(device));
            VMDeviceLoadResult result = device.mount(context);
            context.freeze();
            if (!result.wasSuccessful()) {
                context.invalidate();
                this.mountedDevices.forEach((mountedDevice, mountedContext) -> {
                    mountedDevice.unmount();
                    mountedContext.invalidate();
                });
                this.mountedDevices.clear();
                return result;
            }
            this.mountedDevices.put(device, context);
        }
        this.unmountedDevices.clear();
        this.globalContext.updateReservations();
        return VMDeviceLoadResult.success();
    }

    public void unmountDevices() {
        this.mountedDevices.forEach((device, context) -> {
            device.unmount();
            context.invalidate();
        });
        this.unmountedDevices.addAll(this.mountedDevices.keySet());
        this.mountedDevices.clear();
    }

    public void disposeDevices() {
        this.unmountDevices();
        this.unmountedDevices.forEach(Device::dispose);
    }

    public void addDevices(Collection<Device> devices) {
        for (Device device : devices) {
            VMDevice vmDevice;
            if (!(device instanceof VMDevice) || this.mountedDevices.containsKey(vmDevice = (VMDevice)device)) continue;
            this.unmountedDevices.add(vmDevice);
        }
    }

    public void removeDevices(Collection<Device> devices) {
        for (Device device : devices) {
            if (!(device instanceof VMDevice)) continue;
            VMDevice vmDevice = (VMDevice)device;
            ManagedVMContext context = this.mountedDevices.remove(vmDevice);
            if (context != null) {
                vmDevice.unmount();
                context.invalidate();
                continue;
            }
            this.unmountedDevices.remove(vmDevice);
        }
    }
}

