/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.escapes.csi;

import java.util.Arrays;
import java.util.HashMap;
import li.cil.oc2.common.vm.terminal.Terminal;
import li.cil.oc2.common.vm.terminal.escapes.EscapeUtilities;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH1;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH10;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH11;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH2;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH3;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH4;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH5;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH6;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH7;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH8;
import li.cil.oc2.common.vm.terminal.escapes.csi.CH9;
import li.cil.oc2.common.vm.terminal.escapes.csi.CHA;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSISequenceHandler;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSIState;
import li.cil.oc2.common.vm.terminal.escapes.csi.CUB;
import li.cil.oc2.common.vm.terminal.escapes.csi.CUD;
import li.cil.oc2.common.vm.terminal.escapes.csi.CUF;
import li.cil.oc2.common.vm.terminal.escapes.csi.CUP;
import li.cil.oc2.common.vm.terminal.escapes.csi.CUU;
import li.cil.oc2.common.vm.terminal.escapes.csi.DA;
import li.cil.oc2.common.vm.terminal.escapes.csi.DL;
import li.cil.oc2.common.vm.terminal.escapes.csi.DSR;
import li.cil.oc2.common.vm.terminal.escapes.csi.ECH;
import li.cil.oc2.common.vm.terminal.escapes.csi.ED;
import li.cil.oc2.common.vm.terminal.escapes.csi.EL;
import li.cil.oc2.common.vm.terminal.escapes.csi.HVP;
import li.cil.oc2.common.vm.terminal.escapes.csi.IL;
import li.cil.oc2.common.vm.terminal.escapes.csi.SGR;
import li.cil.oc2.common.vm.terminal.escapes.csi.TBC;
import li.cil.oc2.common.vm.terminal.escapes.csi.VPA;

public class CSIManager {
    private final int[] args = new int[10];
    private int argCount = 0;
    private boolean questionMark = false;
    private boolean greaterThan = false;
    private boolean dollarSign = false;
    private boolean hash = false;
    private boolean quote = false;
    private boolean singleQuote = false;
    private boolean space = false;
    private boolean exclamation = false;
    private final Terminal terminal;
    private final HashMap<Character, CSISequenceHandler> sequences = new HashMap();

    public CSIManager(Terminal terminal) {
        this.terminal = terminal;
        this.sequences.put(Character.valueOf('A'), new CUU(terminal));
        this.sequences.put(Character.valueOf('B'), new CUD(terminal));
        this.sequences.put(Character.valueOf('C'), new CUF(terminal));
        this.sequences.put(Character.valueOf('D'), new CUB(terminal));
        this.sequences.put(Character.valueOf('G'), new CHA(terminal));
        this.sequences.put(Character.valueOf('H'), new CUP(terminal));
        this.sequences.put(Character.valueOf('J'), new ED(terminal));
        this.sequences.put(Character.valueOf('K'), new EL(terminal));
        this.sequences.put(Character.valueOf('L'), new IL(terminal));
        this.sequences.put(Character.valueOf('M'), new DL(terminal));
        this.sequences.put(Character.valueOf('P'), new CH10(terminal));
        this.sequences.put(Character.valueOf('S'), new CH8(terminal));
        this.sequences.put(Character.valueOf('T'), new CH9(terminal));
        this.sequences.put(Character.valueOf('X'), new ECH(terminal));
        this.sequences.put(Character.valueOf('c'), new DA(terminal));
        this.sequences.put(Character.valueOf('d'), new VPA(terminal));
        this.sequences.put(Character.valueOf('f'), new HVP(terminal));
        this.sequences.put(Character.valueOf('g'), new TBC(terminal));
        this.sequences.put(Character.valueOf('h'), new CH2(terminal));
        this.sequences.put(Character.valueOf('l'), new CH3(terminal));
        this.sequences.put(Character.valueOf('m'), new SGR(terminal));
        this.sequences.put(Character.valueOf('n'), new DSR(terminal));
        this.sequences.put(Character.valueOf('p'), new CH5(terminal));
        this.sequences.put(Character.valueOf('q'), new CH7(terminal));
        this.sequences.put(Character.valueOf('r'), new CH1(terminal));
        this.sequences.put(Character.valueOf('s'), new CH6(terminal));
        this.sequences.put(Character.valueOf('t'), new CH4(terminal));
        this.sequences.put(Character.valueOf('@'), new CH11(terminal));
    }

    public void handle(char ch) {
        if (ch >= '0' && ch <= '9') {
            if (this.argCount < this.args.length) {
                this.args[this.argCount] = EscapeUtilities.parseArgument(ch, this.args[this.argCount]);
            }
        } else {
            switch (ch) {
                case ' ': {
                    this.space = true;
                    return;
                }
                case '?': {
                    this.questionMark = true;
                    return;
                }
                case '>': {
                    this.greaterThan = true;
                    return;
                }
                case '$': {
                    this.dollarSign = true;
                    return;
                }
                case '#': {
                    this.hash = true;
                    return;
                }
                case '\"': {
                    this.quote = true;
                    return;
                }
                case '\'': {
                    this.singleQuote = true;
                    return;
                }
                case '!': {
                    this.exclamation = true;
                    return;
                }
                case ';': {
                    ++this.argCount;
                    return;
                }
            }
            ++this.argCount;
            this.terminal.state = Terminal.State.NORMAL;
            CSISequenceHandler handler = this.sequences.get(Character.valueOf(ch));
            CSIState state = new CSIState(this.questionMark, this.greaterThan, this.dollarSign, this.hash, this.quote, this.singleQuote, this.space, this.exclamation);
            if (handler != null) {
                handler.execute(this.args, this.argCount, state);
            } else {
                System.out.println("Control sequence: " + ch);
            }
        }
    }

    public void reset() {
        this.questionMark = false;
        this.greaterThan = false;
        this.dollarSign = false;
        this.hash = false;
        this.quote = false;
        this.singleQuote = false;
        this.space = false;
        this.argCount = 0;
        Arrays.fill(this.args, 0);
    }
}

