/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.fonts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc2.common.vm.terminal.fonts.FontHandling;
import li.cil.oc2.common.vm.terminal.fonts.Glyph;

public class UnicodeFontRenderer {
    public final Font font;
    private final Map<Integer, Glyph> glyphCache = new HashMap<Integer, Glyph>();
    private final FontRenderContext frc = new FontRenderContext(null, true, false);
    private final boolean isItalic;

    public UnicodeFontRenderer(Font font, boolean isItalic) {
        int[] characters;
        this.font = font;
        this.isItalic = isItalic;
        String initialSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!@#$%^&*()_+-=_.,:;<>?;':\"\\|`~[]{}1234567890\u25b3\u25bd ";
        for (int character : characters = initialSet.codePoints().toArray()) {
            this.getGlyph(character);
        }
    }

    public Glyph getGlyph(int character) {
        return this.glyphCache.computeIfAbsent(character, this::rasterizeGlyph);
    }

    private Glyph rasterizeGlyph(int character) {
        GlyphVector gv = this.font.createGlyphVector(this.frc, Character.toChars(character));
        BufferedImage img = new BufferedImage(this.isItalic ? 44 : 20, 32, 2);
        Graphics2D g = img.createGraphics();
        g.setFont(this.font);
        g.setColor(Color.WHITE);
        FontMetrics metrics = g.getFontMetrics();
        int ascent = metrics.getAscent();
        g.drawGlyphVector(gv, 0.0f, ascent - 1);
        g.dispose();
        Glyph glyph = new Glyph(img, this.isItalic ? 44 : 20, 32, (int)gv.getGlyphMetrics(0).getAdvance());
        FontHandling.FontAtlas.addGlyph(glyph);
        return glyph;
    }
}

