# 基础知识

本文档包含了关于[电脑](block/computer.md)工作原理的一些基础信息。基础不代表阅读难度低，这里的“基础”指的是所使用的一般概念。

## 架构

电脑运行在单核的通用RISC-V架构上。代表它们有64位寄存器，并支持浮点运算。这令在电脑上引导启动现代Linux内核成为了可能。

### 本机设备

电脑上连接的本机设备是内存映射设备。这代表它们被映射到了物理内存中的某个区域。电脑使用常规的Linux驱动程序与它们交互。

可用的设备以及它们的地址是通过扁平化的设备树传递给电脑上运行的软件的。该数据结构可能包含有关整个操作系统的其他信息，尤其是已安装的[内存](item/memory.md)大小。该数据结构是在启动时复制的，因此后续不能更新内容。这就为什么在更改本机设备（如[网络接口卡](item/network_interface_card.md)）后必须重启电脑。对于需要重启的设备，其提示文本中通常会进行标注。

### HLAPI设备

另一种设备是高级API设备，有时也称为RPC设备。这些设备使用同一个控制器，该控制器通过单个串口设备与电脑通信。所有电脑中都存在该控制器设备，它负责与多个HLAPI设备之间进行报文收发。该控制器使用的协议是简单的，基于JSON报文的协议。默认Linux库提供的`devices` Lua库封装了用于连接此控制器的串行设备。因此，在使用HLAPI设备（如[红石接口方块](block/redstone_interface.md)）时，**强烈**建议使用`devices`库。

由于所用协议的性质，数据传输速率相对有限。因此，大多数设备通常仅提供相对简单的，不需要发送大量数据的API。

## 配置

电脑可以在一定程度上进行配置。内存的大小、以[硬盘](item/hard_drive.md)形式存在的额外存储空间，以及最重要的，安装什么扩展卡。以上项目主要取决于用户的选择。请注意，默认的Linux发行版至少需要20M的内存，建议使用24M。

大多数组件都会增加电脑的整体能耗。只安装必要的组件对节约能耗至关重要。

## Linux

默认的Linux发行版带有一些基本的命令行工具以及编写和运行Lua程序的功能。请参阅手册的[脚本编写](scripting.md)条目以获取有关如何使用Lua与HLAPI设备交互的概述。

本机设备使用常规的Linux驱动程序。例如，硬盘以`/dev/vdaX`设备的形式出现，可以和普通的Linux系统一样格式化与挂载。

电脑提供了两个硬件时钟（RTC）设备。第一个以大多数用户熟悉的时间单位计时。系统默认使用该设备，例如`date`和`time`等命令行工具。第二个时钟计量电脑在世界中运行的时长。要获取当前世界时间，请使用`hwclock -f /dev/rtc1`。
