/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.config;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureData;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.enchants.EnchantManager;
import com.fix3dll.skyblockaddons.mixin.hooks.FontHook;
import com.fix3dll.skyblockaddons.utils.ColorUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_310;
import org.apache.logging.log4j.Logger;

public class ConfigValuesManager {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final int CONFIG_VERSION = 11;
    private static final ReentrantLock SAVE_LOCK = new ReentrantLock();
    private final File configFile;
    private final File settingsConfigFile;
    public static final EnumMap<Feature, FeatureData<?>> DEFAULT_FEATURE_DATA = new EnumMap(Feature.class);
    private boolean firstLoad = true;
    private ConfigValues configValues = new ConfigValues();

    public ConfigValuesManager(File mainConfigDir) {
        this.configFile = mainConfigDir;
        this.settingsConfigFile = new File(mainConfigDir.getAbsolutePath(), "skyblockaddons/configurations.json");
    }

    public void loadValues() {
        block29: {
            Gson gson = SkyblockAddons.getGson();
            if (DEFAULT_FEATURE_DATA.isEmpty()) {
                try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("defaults.json");
                     InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);){
                    DEFAULT_FEATURE_DATA.putAll((Map)gson.fromJson((Reader)inputStreamReader, new TypeToken<EnumMap<Feature, FeatureData<?>>>(this){}.getType()));
                }
                catch (Exception ex) {
                    class_128 crashReport = class_128.method_560((Throwable)ex, (String)"Reading default settings file");
                    throw new class_148(crashReport);
                }
            }
            if (this.settingsConfigFile.exists()) {
                try (BufferedReader reader = Files.newBufferedReader(this.settingsConfigFile.toPath(), StandardCharsets.UTF_8);){
                    this.configValues = gson.fromJson((Reader)reader, ConfigValues.class);
                    if (this.configValues == null) {
                        this.configValues = new ConfigValues();
                        this.configValues.features.putAll(this.deepCopyDefaults());
                    } else if (this.configValues.features.isEmpty()) {
                        this.configValues.features.putAll(this.deepCopyDefaults());
                    }
                    this.overwriteFeatureData();
                }
                catch (Exception ex) {
                    if (this.configValues == null || this.configValues.isEmpty()) {
                        LOGGER.error("The configuration file is corrupt! After the previous file is backed up, it will be restored to default.", (Throwable)ex);
                        this.backupConfig(true);
                        this.addDefaultsAndSave();
                        break block29;
                    }
                    LOGGER.error("Error loading configuration values!", (Throwable)ex);
                }
            } else {
                this.addDefaultsAndSave();
            }
        }
        this.firstLoad = false;
        Feature.TURN_ALL_FEATURES_CHROMA.setEnabled(ColorUtils.areAllFeaturesChroma());
        FontHook.setAllTextChroma(Feature.TURN_ALL_TEXTS_CHROMA.isChroma());
    }

    private void addDefaultsAndSave() {
        this.configValues.features.putAll(this.deepCopyDefaults());
        this.overwriteFeatureData();
        this.saveConfig();
    }

    private void overwriteFeatureData() {
        if (this.firstLoad) {
            for (Feature feature : Feature.values()) {
                this.configValues.features.computeIfAbsent(feature, k -> DEFAULT_FEATURE_DATA.get(k).deepCopy());
            }
        }
        for (Map.Entry entry : this.configValues.features.entrySet()) {
            Feature feature = (Feature)((Object)entry.getKey());
            FeatureData featureData = (FeatureData)entry.getValue();
            if (featureData != null) {
                if (this.firstLoad) {
                    this.firstLoadChecks(feature, featureData);
                }
                feature.getFeatureData().overwriteData(featureData);
                continue;
            }
            FeatureData<?> defaultData = DEFAULT_FEATURE_DATA.get((Object)feature);
            if (defaultData != null) {
                feature.getFeatureData().overwriteData(defaultData);
                LOGGER.warn("Default FeatureData loaded for {} feature.", (Object)feature);
                continue;
            }
            throw new IllegalStateException("There is no default FeatureData for " + String.valueOf((Object)feature));
        }
    }

    private void firstLoadChecks(Feature feature, FeatureData<?> featureData) {
        TreeMap<FeatureSetting, Object> settings = featureData.getSettings();
        FeatureData<?> defaultFeatureData = DEFAULT_FEATURE_DATA.get((Object)feature);
        TreeMap<FeatureSetting, Object> defaultSettings = defaultFeatureData.getSettings();
        if (featureData.getValue().getClass() != defaultFeatureData.getValue().getClass()) {
            featureData.setValue(defaultFeatureData.getValue());
            LOGGER.warn("The corrupted value of the '{}' Feature was reset to its default value.", (Object)feature);
        }
        if (settings == null && defaultSettings != null) {
            featureData.setSettings(new TreeMap<FeatureSetting, Object>());
            settings = featureData.getSettings();
        }
        if (settings != null && defaultSettings != null) {
            for (Map.Entry<FeatureSetting, Object> settingsEntry : defaultSettings.entrySet()) {
                FeatureSetting defaultSetting = settingsEntry.getKey();
                Object defaultValue = settingsEntry.getValue();
                if (!settings.containsKey((Object)defaultSetting)) {
                    settings.put(defaultSetting, defaultValue);
                    LOGGER.info("Default '{}' FeatureSetting loaded for '{}' Feature.", (Object)defaultSetting, (Object)feature);
                    continue;
                }
                if (defaultValue.getClass() == settings.get((Object)defaultSetting).getClass()) continue;
                settings.put(defaultSetting, defaultValue);
                LOGGER.warn("'{}' FeatureSetting for '{}' Feature has been updated with new defaults!", (Object)defaultSetting, (Object)feature);
            }
        }
    }

    public void saveConfig() {
        EnchantManager.markCacheDirty();
        SkyblockAddons.runAsync(() -> {
            boolean isDevMode;
            block13: {
                if (!SAVE_LOCK.tryLock()) {
                    return;
                }
                isDevMode = Feature.DEVELOPER_MODE.isEnabled();
                if (isDevMode) {
                    LOGGER.info("Saving config...");
                }
                this.configValues.configVersion = 11;
                for (Feature feature : Feature.values()) {
                    this.configValues.features.put(feature, feature.getFeatureData());
                    if (feature.getId() <= this.configValues.lastFeatureId) continue;
                    this.configValues.lastFeatureId = feature.getId();
                }
                try {
                    File tempFile = File.createTempFile(this.settingsConfigFile.getName(), ".tmp", this.settingsConfigFile.getParentFile());
                    try (BufferedWriter writer = Files.newBufferedWriter(tempFile.toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        SkyblockAddons.getGson().toJson((Object)this.configValues, (Appendable)writer);
                    }
                    Files.move(tempFile.toPath(), this.settingsConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Exception ex) {
                    LOGGER.error("Error saving configurations file!", (Throwable)ex);
                    if (class_310.method_1551().field_1724 == null) break block13;
                    Utils.sendErrorMessage("Error saving configurations file! Check log for more detail.");
                }
            }
            SAVE_LOCK.unlock();
            if (isDevMode) {
                LOGGER.info("Config saved!");
            }
        });
    }

    public void setSettingToDefault(FeatureSetting setting) {
        Feature feature = setting.getRelatedFeature();
        if (feature != null) {
            FeatureData<?> data = Objects.requireNonNull(DEFAULT_FEATURE_DATA.get((Object)feature), "There is no default FeatureData for " + String.valueOf((Object)feature));
            TreeMap<FeatureSetting, Object> settings = Objects.requireNonNull(data.getSettings(), "There is no default settings for " + String.valueOf((Object)feature));
            Object defaultValue = Objects.requireNonNull(settings.get((Object)setting), "There is no default value for '" + String.valueOf((Object)setting) + "' setting!");
            if (feature.hasSettings()) {
                feature.set(setting, defaultValue);
            } else {
                feature.getFeatureData().setSettings(settings);
            }
            if (Feature.DEVELOPER_MODE.isEnabled()) {
                LOGGER.info("{} has been set to default value.", (Object)setting.name());
            }
            return;
        }
        if (Feature.DEVELOPER_MODE.isEnabled()) {
            LOGGER.error("Could not reset {} to its default value.", (Object)setting.name());
        }
    }

    public void restoreFeatureDefaultValue(Feature feature) {
        FeatureData<?> defaultData = Objects.requireNonNull(DEFAULT_FEATURE_DATA.get((Object)feature), "There is no default FeatureData for " + String.valueOf((Object)feature));
        Object defaultValue = Objects.requireNonNull(defaultData.getValue(), "There is no default value for '" + String.valueOf((Object)feature) + "' Feature!");
        feature.setValue(defaultValue);
        LOGGER.warn("The value of the '{}' Feature is reset to its default value.", (Object)feature);
    }

    public void setAllCoordinatesToDefault() {
        for (Map.Entry<Feature, FeatureData<?>> entry : DEFAULT_FEATURE_DATA.entrySet()) {
            Feature feature = entry.getKey();
            FeatureData<?> featureData = entry.getValue();
            if (featureData.getCoords() == null) continue;
            feature.getFeatureData().setCoords(featureData.getCoords().clonePair());
            feature.getFeatureData().setAnchorPoint(featureData.getAnchorPoint());
            feature.getFeatureData().setGuiScale(featureData.getGuiScale());
        }
    }

    public void putDefaultCoordinates(Feature feature) {
        Pair<Float, Float> coords = DEFAULT_FEATURE_DATA.get((Object)feature).getCoords();
        if (coords != null) {
            feature.getFeatureData().setCoords(coords.clonePair());
        }
    }

    public void putDefaultBarSizes() {
        for (Map.Entry<Feature, FeatureData<?>> entry : DEFAULT_FEATURE_DATA.entrySet()) {
            Feature feature = entry.getKey();
            FeatureData<?> featureData = entry.getValue();
            feature.getFeatureData().setBarSizes(featureData.getBarSizes().clonePair());
        }
    }

    public void putDefaultGuiScale(Feature feature) {
        float defaultScale = DEFAULT_FEATURE_DATA.get((Object)feature).getGuiScale();
        feature.setGuiScale(defaultScale);
    }

    public EnumMap<Feature, FeatureData<?>> deepCopyDefaults() {
        Gson gson = SkyblockAddons.getGson();
        String json = gson.toJson(DEFAULT_FEATURE_DATA);
        return (EnumMap)gson.fromJson(json, new TypeToken<EnumMap<Feature, FeatureData<?>>>(this){}.getType());
    }

    public void backupConfig(boolean corrupted) {
        if (!this.settingsConfigFile.exists()) {
            LOGGER.warn("configurations.json file for backup is not exist!");
            return;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm");
            String formattedDate = ZonedDateTime.now().format(formatter);
            String extension = corrupted ? ".corrupted" : ".backup";
            String backupFileName = "configurations.json." + formattedDate + extension;
            File backupFile = new File(this.configFile, "/skyblockaddons/backup/" + backupFileName);
            Files.createDirectories(backupFile.getParentFile().toPath(), new FileAttribute[0]);
            Files.copy(this.settingsConfigFile.toPath(), backupFile.toPath(), new CopyOption[0]);
            LOGGER.info("Configurations backed up successfully: {}", (Object)backupFile.getPath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to backup configurations file!", (Throwable)e);
        }
    }

    @Generated
    public void setFirstLoad(boolean firstLoad) {
        this.firstLoad = firstLoad;
    }

    public static class ConfigValues {
        private int configVersion = Integer.MIN_VALUE;
        private int lastFeatureId = Integer.MIN_VALUE;
        private EnumMap<Feature, FeatureData<?>> features = new EnumMap(Feature.class);

        public boolean isEmpty() {
            return this.configVersion == Integer.MIN_VALUE && this.lastFeatureId == Integer.MIN_VALUE && this.features.isEmpty();
        }

        @Generated
        public void setConfigVersion(int configVersion) {
            this.configVersion = configVersion;
        }

        @Generated
        public void setLastFeatureId(int lastFeatureId) {
            this.lastFeatureId = lastFeatureId;
        }

        @Generated
        public void setFeatures(EnumMap<Feature, FeatureData<?>> features) {
            this.features = features;
        }
    }
}

