/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core;

import com.fix3dll.skyblockaddons.utils.ItemUtils;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;

public enum ThunderBottle {
    THUNDER_IN_A_BOTTLE_EMPTY(null, 0, 50000),
    STORM_IN_A_BOTTLE_EMPTY(null, 0, 500000),
    HURRICANE_IN_A_BOTTLE_EMPTY(null, 0, 5000000),
    THUNDER_IN_A_BOTTLE(null),
    STORM_IN_A_BOTTLE(null),
    HURRICANE_IN_A_BOTTLE(null);

    private class_1799 itemStack;
    private int charge;
    private final int capacity;
    private int slot;

    private ThunderBottle(class_1799 itemStack) {
        this(itemStack, 0, 0);
    }

    private ThunderBottle(class_1799 itemStack, int charge, int capacity) {
        this.itemStack = itemStack;
        this.charge = charge;
        this.capacity = capacity;
    }

    public static void updateThunderBottles(class_2371<class_1799> inventory) {
        if (inventory.isEmpty()) {
            return;
        }
        boolean foundFullThunderBottle = false;
        int displayOrder = Integer.MAX_VALUE;
        for (int slot = 0; slot < inventory.size(); ++slot) {
            class_1799 itemStack = (class_1799)inventory.get(slot);
            if (itemStack == class_1799.field_8037 || itemStack.method_7909() != class_1802.field_8575) continue;
            String itemID = ItemUtils.getSkyblockItemID(itemStack);
            for (ThunderBottle bottle : ThunderBottle.values()) {
                if (!bottle.name().equals(itemID) || bottle.ordinal() >= displayOrder) continue;
                bottle.itemStack = itemStack;
                bottle.slot = slot;
                displayOrder = bottle.ordinal();
                if (bottle.isFull()) {
                    foundFullThunderBottle = true;
                    continue;
                }
                bottle.charge = ItemUtils.getThunderCharge(itemStack);
            }
        }
        for (ThunderBottle bottle : ThunderBottle.values()) {
            if (bottle.ordinal() > displayOrder || displayOrder == Integer.MAX_VALUE) {
                bottle.itemStack = null;
                bottle.slot = -1;
                bottle.charge = 0;
                continue;
            }
            if (foundFullThunderBottle || !bottle.isFull()) continue;
            bottle.itemStack = null;
            bottle.slot = -1;
        }
    }

    public static ThunderBottle getDisplayBottle() {
        for (ThunderBottle bottle : ThunderBottle.values()) {
            if (bottle.itemStack == null) continue;
            return bottle;
        }
        return null;
    }

    public boolean isFull() {
        return this.capacity == 0;
    }

    @Generated
    public class_1799 getItemStack() {
        return this.itemStack;
    }

    @Generated
    public int getCharge() {
        return this.charge;
    }

    @Generated
    public int getCapacity() {
        return this.capacity;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public void setItemStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    @Generated
    public void setCharge(int charge) {
        this.charge = charge;
    }

    @Generated
    public void setSlot(int slot) {
        this.slot = slot;
    }
}

