/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core.feature;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.feature.FeatureGuiData;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.fix3dll.skyblockaddons.utils.objects.RegistrableEnum;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.TreeMap;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.Logger;

public class FeatureData<T> {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private final FeatureGuiData guiData;
    @SerializedName(value="value")
    private T value;
    @SerializedName(value="anchorPoint")
    private EnumUtils.AnchorPoint anchorPoint;
    @SerializedName(value="coords")
    private Pair<Float, Float> coords;
    @SerializedName(value="barSizes")
    @NonNull
    private Pair<Float, Float> barSizes = new Pair<Float, Float>(Float.valueOf(1.0f), Float.valueOf(1.0f));
    @SerializedName(value="guiScale")
    private float guiScale = 1.0f;
    @SerializedName(value="color")
    private int color = ColorCode.RED.getColor();
    @SerializedName(value="chroma")
    private boolean chroma = false;
    @SerializedName(value="settings")
    private TreeMap<FeatureSetting, Object> settings = null;

    public FeatureData<T> deepCopy() {
        Gson gson = SkyblockAddons.getGson();
        String json = gson.toJson(this);
        return (FeatureData)gson.fromJson(json, new TypeToken<FeatureData<?>>(this){}.getType());
    }

    public void overwriteData(FeatureData<?> guiData) {
        this.value = guiData.getValue();
        this.anchorPoint = guiData.getAnchorPoint();
        this.coords = guiData.getCoords();
        this.barSizes = guiData.getBarSizes();
        this.guiScale = guiData.getGuiScale();
        this.color = guiData.getColor();
        this.chroma = guiData.isChroma();
        this.settings = guiData.getSettings();
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public <V> void setSetting(FeatureSetting setting, V value) {
        if (FeatureData.isValidValue(value)) {
            if (this.hasSettings()) {
                this.settings.put(setting, value);
            } else {
                TreeMap<FeatureSetting, V> newSettings = new TreeMap<FeatureSetting, V>();
                newSettings.put(setting, value);
                this.settings = newSettings;
            }
        } else {
            throw new IllegalStateException("Tried to set invalid value to '" + String.valueOf((Object)setting) + "'. Value type: " + String.valueOf(value));
        }
    }

    public boolean hasSettings() {
        return this.settings != null && !this.settings.isEmpty();
    }

    public static boolean isValidValue(Object value) {
        return value instanceof Boolean || value instanceof Number || value instanceof RegistrableEnum || value instanceof String;
    }

    public void setCoords(float x, float y) {
        if (this.coords != null) {
            this.coords.setLeft(Float.valueOf(x));
            this.coords.setRight(Float.valueOf(y));
        } else {
            this.coords = new Pair<Float, Float>(Float.valueOf(x), Float.valueOf(y));
        }
    }

    public float getSizesX() {
        return Math.min(Math.max(this.barSizes.getLeft().floatValue(), 0.25f), 1.0f);
    }

    public float getSizesY() {
        return Math.min(Math.max(this.barSizes.getRight().floatValue(), 0.25f), 1.0f);
    }

    @Generated
    public FeatureData(FeatureGuiData guiData) {
        this.guiData = guiData;
    }

    @Generated
    public FeatureGuiData getGuiData() {
        return this.guiData;
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public EnumUtils.AnchorPoint getAnchorPoint() {
        return this.anchorPoint;
    }

    @Generated
    public Pair<Float, Float> getCoords() {
        return this.coords;
    }

    @NonNull
    @Generated
    public Pair<Float, Float> getBarSizes() {
        return this.barSizes;
    }

    @Generated
    public float getGuiScale() {
        return this.guiScale;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public boolean isChroma() {
        return this.chroma;
    }

    @Generated
    public TreeMap<FeatureSetting, Object> getSettings() {
        return this.settings;
    }

    @Generated
    public void setAnchorPoint(EnumUtils.AnchorPoint anchorPoint) {
        this.anchorPoint = anchorPoint;
    }

    @Generated
    public void setCoords(Pair<Float, Float> coords) {
        this.coords = coords;
    }

    @Generated
    public void setBarSizes(@NonNull Pair<Float, Float> barSizes) {
        if (barSizes == null) {
            throw new NullPointerException("barSizes is marked non-null but is null");
        }
        this.barSizes = barSizes;
    }

    @Generated
    public void setGuiScale(float guiScale) {
        this.guiScale = guiScale;
    }

    @Generated
    public void setColor(int color) {
        this.color = color;
    }

    @Generated
    public void setChroma(boolean chroma) {
        this.chroma = chroma;
    }

    @Generated
    public void setSettings(TreeMap<FeatureSetting, Object> settings) {
        this.settings = settings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureData)) {
            return false;
        }
        FeatureData other = (FeatureData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getGuiScale(), other.getGuiScale()) != 0) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        if (this.isChroma() != other.isChroma()) {
            return false;
        }
        FeatureGuiData this$guiData = this.getGuiData();
        FeatureGuiData other$guiData = other.getGuiData();
        if (this$guiData == null ? other$guiData != null : !this$guiData.equals(other$guiData)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        EnumUtils.AnchorPoint this$anchorPoint = this.getAnchorPoint();
        EnumUtils.AnchorPoint other$anchorPoint = other.getAnchorPoint();
        if (this$anchorPoint == null ? other$anchorPoint != null : !this$anchorPoint.equals(other$anchorPoint)) {
            return false;
        }
        Pair<Float, Float> this$coords = this.getCoords();
        Pair<Float, Float> other$coords = other.getCoords();
        if (this$coords == null ? other$coords != null : !this$coords.equals(other$coords)) {
            return false;
        }
        Pair<Float, Float> this$barSizes = this.getBarSizes();
        Pair<Float, Float> other$barSizes = other.getBarSizes();
        if (this$barSizes == null ? other$barSizes != null : !this$barSizes.equals(other$barSizes)) {
            return false;
        }
        TreeMap<FeatureSetting, Object> this$settings = this.getSettings();
        TreeMap<FeatureSetting, Object> other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeatureData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getGuiScale());
        result = result * 59 + this.getColor();
        result = result * 59 + (this.isChroma() ? 79 : 97);
        FeatureGuiData $guiData = this.getGuiData();
        result = result * 59 + ($guiData == null ? 43 : $guiData.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        EnumUtils.AnchorPoint $anchorPoint = this.getAnchorPoint();
        result = result * 59 + ($anchorPoint == null ? 43 : $anchorPoint.hashCode());
        Pair<Float, Float> $coords = this.getCoords();
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        Pair<Float, Float> $barSizes = this.getBarSizes();
        result = result * 59 + ($barSizes == null ? 43 : $barSizes.hashCode());
        TreeMap<FeatureSetting, Object> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FeatureData(guiData=" + String.valueOf(this.getGuiData()) + ", value=" + String.valueOf(this.getValue()) + ", anchorPoint=" + String.valueOf(this.getAnchorPoint()) + ", coords=" + String.valueOf(this.getCoords()) + ", barSizes=" + String.valueOf(this.getBarSizes()) + ", guiScale=" + this.getGuiScale() + ", color=" + this.getColor() + ", chroma=" + this.isChroma() + ", settings=" + String.valueOf(this.getSettings()) + ")";
    }
}

