/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core.render.state;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import lombok.Generated;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public final class CornerRenderState
extends Record
implements class_11244 {
    private final RenderPipeline pipeline;
    private final class_11231 textureSetup;
    private final Matrix3x2f pose;
    private final float x;
    private final float y;
    private final float radius;
    private final RoundedRectCorner corner;
    private final int color;
    @Nullable
    private final class_8030 scissorArea;
    @Nullable
    private final class_8030 bounds;

    public CornerRenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, float x, float y, float radius, RoundedRectCorner corner, int color, @Nullable class_8030 scissorArea, @Nullable class_8030 bounds) {
        pose = new Matrix3x2f((Matrix3x2fc)pose);
        this.pipeline = pipeline;
        this.textureSetup = textureSetup;
        this.pose = pose;
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.corner = corner;
        this.color = color;
        this.scissorArea = scissorArea;
        this.bounds = bounds;
    }

    public CornerRenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, float x, float y, float radius, RoundedRectCorner corner, int color, @Nullable class_8030 scissorArea) {
        this(pipeline, textureSetup, pose, x, y, radius, corner, color, scissorArea, CornerRenderState.getBounds(Math.round(x), Math.round(y), Math.round(x + radius), Math.round(y + radius), pose, scissorArea));
    }

    public void method_70917(class_4588 consumer) {
        int segments = 64;
        double angleStep = 1.5707964f / (float)segments;
        double startAngle = this.corner.startAngle;
        float prevX = this.x + (float)Math.cos(startAngle) * this.radius;
        float prevY = this.y + (float)Math.sin(startAngle) * this.radius;
        for (int segment = 0; segment <= segments; ++segment) {
            double angle = startAngle - angleStep * (double)segment;
            float newX = this.x + (float)(Math.cos(angle) * (double)this.radius);
            float newY = this.y + (float)(Math.sin(angle) * (double)this.radius);
            consumer.method_70815(this.pose, newX, newY).method_39415(this.color);
        }
        consumer.method_70815(this.pose, this.x, this.y).method_39415(this.color);
        consumer.method_70815(this.pose, prevX, prevY).method_39415(this.color);
    }

    @Nullable
    private static class_8030 getBounds(int x0, int y0, int x1, int y1, Matrix3x2f pose, @Nullable class_8030 scissorArea) {
        class_8030 screenRectangle = new class_8030(x0, y0, x1 - x0, y1 - y0).method_71523(pose);
        return scissorArea != null ? scissorArea.method_49701(screenRectangle) : screenRectangle;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CornerRenderState.class, "pipeline;textureSetup;pose;x;y;radius;corner;color;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x", "y", "radius", "corner", "color", "scissorArea", "bounds"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CornerRenderState.class, "pipeline;textureSetup;pose;x;y;radius;corner;color;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x", "y", "radius", "corner", "color", "scissorArea", "bounds"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CornerRenderState.class, "pipeline;textureSetup;pose;x;y;radius;corner;color;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x", "y", "radius", "corner", "color", "scissorArea", "bounds"}, this, o);
    }

    public RenderPipeline comp_4055() {
        return this.pipeline;
    }

    public class_11231 comp_4056() {
        return this.textureSetup;
    }

    public Matrix3x2f pose() {
        return this.pose;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float radius() {
        return this.radius;
    }

    public RoundedRectCorner corner() {
        return this.corner;
    }

    public int color() {
        return this.color;
    }

    @Nullable
    public class_8030 comp_4069() {
        return this.scissorArea;
    }

    @Nullable
    public class_8030 comp_4274() {
        return this.bounds;
    }

    public static enum RoundedRectCorner {
        TOP_LEFT(-1.5707963705062866),
        TOP_RIGHT(0.0),
        BOTTOM_LEFT(1.5707963705062866),
        BOTTOM_RIGHT(Math.PI);

        private final double startAngle;

        @Generated
        private RoundedRectCorner(double startAngle) {
            this.startAngle = startAngle;
        }
    }
}

